/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400AbstractTime;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class AS400Time
extends AS400AbstractTime {
    static final long serialVersionUID = 4L;
    private Time defaultValue_;
    private static Hashtable formatsMap_;
    public static final Time MIN_VALUE;
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;
    public static final Time MAX_VALUE;
    public static final int FORMAT_HMS = 100;
    public static final int FORMAT_ISO = 101;
    public static final int FORMAT_USA = 102;
    public static final int FORMAT_EUR = 103;
    public static final int FORMAT_JIS = 104;
    private static final int FORMAT_RANGE_MINIMUM = 100;
    private static final int FORMAT_RANGE_MAXIMUM = 104;
    static /* synthetic */ Class class$com$ibm$as400$access$AS400Time;
    static /* synthetic */ Class class$java$sql$Time;

    public AS400Time() {
        this(101);
    }

    public AS400Time(TimeZone timeZone) {
        this(timeZone, 101);
    }

    public AS400Time(int n) {
        this.setFormat(n, this.defaultSeparatorFor(n));
    }

    public AS400Time(TimeZone timeZone, int n) {
        super(timeZone);
        this.setFormat(n, this.defaultSeparatorFor(n));
    }

    public AS400Time(int n, Character c) {
        this.setFormat(n, c);
    }

    public AS400Time(TimeZone timeZone, int n, Character c) {
        super(timeZone);
        this.setFormat(n, c);
    }

    public int getFormat() {
        return super.getFormat();
    }

    public Character getSeparator() {
        return super.getSeparator();
    }

    public void setFormat(int n) {
        super.setFormat(n, this.defaultSeparatorFor(n));
    }

    void setFormat(String string) {
        super.setFormat(AS400Time.toFormat(string));
    }

    void setSeparator(Character c) {
        super.setSeparator(c);
    }

    public void setFormat(int n, Character c) {
        super.setFormat(n, c);
    }

    public void setFormat(int n, char c) {
        super.setFormat(n, new Character(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getFormatsMap() {
        if (formatsMap_ == null) {
            Class clazz = class$com$ibm$as400$access$AS400Time == null ? (class$com$ibm$as400$access$AS400Time = AS400Time.class$("com.ibm.as400.access.AS400Time")) : class$com$ibm$as400$access$AS400Time;
            synchronized (clazz) {
                if (formatsMap_ == null) {
                    formatsMap_ = new Hashtable(12);
                    formatsMap_.put("HMS", new Integer(100));
                    formatsMap_.put("ISO", new Integer(101));
                    formatsMap_.put("USA", new Integer(102));
                    formatsMap_.put("EUR", new Integer(103));
                    formatsMap_.put("JIS", new Integer(104));
                }
            }
        }
        return formatsMap_;
    }

    public static int toFormat(String string) {
        if (string == null || string.length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "AS400Time.toFormat(" + string + "): Returning default time format.");
            }
            return 101;
        }
        Integer n = (Integer)AS400Time.getFormatsMap().get(string.trim().toUpperCase());
        if (n == null) {
            throw new ExtendedIllegalArgumentException("format (" + string + ")", 2);
        }
        return n;
    }

    public Object getDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = new Time(0L);
        }
        return this.defaultValue_;
    }

    public int getInstanceType() {
        return 18;
    }

    public Class getJavaType() {
        return class$java$sql$Time == null ? (class$java$sql$Time = AS400Time.class$("java.sql.Time")) : class$java$sql$Time;
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        return super.toBytes(object, byArray, n);
    }

    public Object toObject(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("as400Value");
        }
        String string = this.getCharConverter().byteArrayToString(byArray, n, this.getLength());
        return this.parse(string);
    }

    public String toString(Object object) {
        Time time;
        if (object == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            time = (Time)object;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "javaValue is of type " + object.getClass().getName());
            throw classCastException;
        }
        return this.getDateFormatter().format(time);
    }

    public Time parse(String string) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        try {
            SimpleDateFormat simpleDateFormat = this.getDateFormatter();
            Date date = simpleDateFormat.parse(string);
            long l = date.getTime();
            Time time = new Time(l);
            return time;
        }
        catch (Exception exception) {
            Trace.log(2, exception.getMessage(), string);
            Trace.log(2, "Time string is expected to be in format: " + this.patternFor(this.getFormat(), this.getSeparator()));
            throw new ExtendedIllegalArgumentException("source (" + string + ")", 2);
        }
    }

    public static Time parseXsdString(String string) {
        return AS400Time.parseXsdString(string, AS400AbstractTime.TIMEZONE_GMT);
    }

    public static Time parseXsdString(String string, TimeZone timeZone) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        try {
            Date date = AS400AbstractTime.getTimeFormatterXSD(timeZone).parse(string);
            long l = date.getTime();
            Time time = new Time(l);
            return time;
        }
        catch (ParseException parseException) {
            Trace.log(2, parseException.getMessage(), string);
            Trace.log(2, "Value is expected to be in standard XML Schema 'time' format: HH:mm:ss");
            throw new ExtendedIllegalArgumentException("source (" + string + ")", 2);
        }
    }

    public static String toXsdString(Object object) {
        return AS400Time.toXsdString(object, AS400AbstractTime.TIMEZONE_GMT);
    }

    public static String toXsdString(Object object, TimeZone timeZone) {
        Time time;
        if (object == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            time = (Time)object;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "javaValue is of type " + object.getClass().getName());
            throw classCastException;
        }
        return AS400AbstractTime.getTimeFormatterXSD(timeZone).format(time);
    }

    String patternFor(int n, Character c) {
        String string = c == null ? "" : c.toString();
        switch (n) {
            case 102: {
                String string2 = string.equals("") ? "" : " ";
                return "hh" + string + "mm" + string2 + "a";
            }
        }
        return "HH" + string + "mm" + string + "ss";
    }

    Character defaultSeparatorFor(int n) {
        if (!this.isValidFormat(n)) {
            throw new ExtendedIllegalArgumentException("format (" + n + ")", 2);
        }
        switch (n) {
            case 100: 
            case 102: 
            case 104: {
                return AS400AbstractTime.COLON;
            }
            case 101: 
            case 103: {
                return AS400AbstractTime.PERIOD;
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + n);
    }

    boolean isValidFormat(int n) {
        return AS400Time.validateFormat(n);
    }

    public static boolean validateFormat(int n) {
        return n >= 100 && n <= 104;
    }

    public static int getByteLength(int n, Character c) {
        if (c == null) {
            return 6;
        }
        return 8;
    }

    int lengthFor(int n) {
        return AS400Time.getByteLength(n, this.getSeparator());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        MIN_VALUE = new Time(0L);
        MAX_VALUE = new Time(86399999L);
    }
}

