/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPartitionScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;

public class SQLPartitionScanner
extends RuleBasedPartitionScanner
implements TPPartitionScanner {
    private static final Log log = Log.getLog(SQLPartitionScanner.class);
    private final DBPDataSource dataSource;
    private final List<IPredicateRule> rules = new ArrayList<IPredicateRule>();
    private final IToken commentToken = new Token((Object)"sql_comment");
    private final IToken multilineCommentToken = new Token((Object)"sql_multiline_comment");
    private final IToken sqlStringToken = new Token((Object)"sql_character");
    private final IToken sqlQuotedToken = new Token((Object)"sql_quoted");

    private void setupRules() {
        IPredicateRule[] result = new IPredicateRule[this.rules.size()];
        this.rules.toArray(result);
        this.setPredicateRules(result);
    }

    private void initRules(SQLDialect dialect, SQLRuleManager ruleManager) {
        String[] singleLineComments;
        int n;
        int n2;
        String[][] stringArray;
        TPRuleProvider ruleProvider = (TPRuleProvider)GeneralUtils.adapt((Object)dialect, TPRuleProvider.class);
        if (ruleProvider != null) {
            ArrayList partRules = new ArrayList();
            ruleProvider.extendRules(this.dataSource == null ? null : this.dataSource.getContainer(), partRules, TPRuleProvider.RulePosition.PARTITION);
            for (TPRule pr : partRules) {
                if (!(pr instanceof TPPredicateRule)) continue;
                this.rules.add(new PredicateRuleAdapter((TPPredicateRule)pr));
            }
        }
        boolean hasDoubleQuoteRule = false;
        String[][] identifierQuoteStrings = dialect.getIdentifierQuoteStrings();
        String[][] stringQuoteStrings = dialect.getStringQuoteStrings();
        char stringEscapeCharacter = dialect.getStringEscapeCharacter();
        if (identifierQuoteStrings != null) {
            stringArray = identifierQuoteStrings;
            n2 = identifierQuoteStrings.length;
            n = 0;
            while (n < n2) {
                String[] quoteString = stringArray[n];
                this.rules.add((IPredicateRule)new MultiLineRule(quoteString[0], quoteString[1], this.sqlQuotedToken, stringEscapeCharacter));
                if (quoteString[1].equals("\"") && quoteString[0].equals(quoteString[1])) {
                    hasDoubleQuoteRule = true;
                }
                ++n;
            }
        }
        if (!hasDoubleQuoteRule) {
            this.rules.add((IPredicateRule)new MultiLineRule("\"", "\"", this.sqlQuotedToken, stringEscapeCharacter));
        }
        if (!ArrayUtils.isEmpty((Object[])stringQuoteStrings)) {
            stringArray = stringQuoteStrings;
            n2 = stringQuoteStrings.length;
            n = 0;
            while (n < n2) {
                String[] quotes = stringArray[n];
                this.rules.add((IPredicateRule)new MultiLineRule(quotes[0], quotes[1], this.sqlStringToken, stringEscapeCharacter));
                ++n;
            }
        }
        EmptyCommentRule wordRule = new EmptyCommentRule(this.multilineCommentToken);
        this.rules.add(wordRule);
        TPRule multiLineCommentRule = ruleManager.getMultiLineCommentRule();
        if (multiLineCommentRule instanceof TPPredicateRule) {
            this.rules.add(new PredicateRuleAdapter((TPPredicateRule)multiLineCommentRule));
        }
        String[] stringArray2 = singleLineComments = dialect.getSingleLineComments();
        int n3 = singleLineComments.length;
        int n4 = 0;
        while (n4 < n3) {
            String singleLineComment = stringArray2[n4];
            this.rules.add((IPredicateRule)new EndOfLineRule(singleLineComment, this.commentToken));
            ++n4;
        }
    }

    public SQLPartitionScanner(DBPDataSource dataSource, SQLDialect dialect, SQLRuleManager ruleManager) {
        this.dataSource = dataSource;
        this.initRules(dialect, ruleManager);
        this.setupRules();
    }

    public String getScannedPartitionString() {
        try {
            return this.fDocument.get(this.fPartitionOffset, this.fOffset - this.fPartitionOffset);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static ITypedRegion[] getDocumentRegions(IDocument doc) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning((IDocument)doc, (String)"___sql_partitioning", (int)0, (int)doc.getLength(), (boolean)false);
        }
        catch (BadLocationException badLocationException) {}
        return regions;
    }

    private IToken adaptToken(TPToken token) {
        if (token instanceof TPTokenDefault && token.getData() instanceof SQLTokenType) {
            switch ((SQLTokenType)token.getData()) {
                case T_STRING: {
                    return this.sqlStringToken;
                }
                case T_QUOTED: {
                    return this.sqlQuotedToken;
                }
                case T_COMMENT: {
                    return this.multilineCommentToken;
                }
            }
        }
        return Token.UNDEFINED;
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken successToken;

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.successToken = successToken;
            this.addWord("/**/", this.successToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.successToken;
        }
    }

    private class PredicateRuleAdapter
    implements IPredicateRule {
        private final TPPredicateRule rule;

        PredicateRuleAdapter(TPPredicateRule rule) {
            this.rule = rule;
        }

        public IToken getSuccessToken() {
            return SQLPartitionScanner.this.adaptToken(this.rule.getSuccessToken());
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return SQLPartitionScanner.this.adaptToken(this.rule.evaluate((TPCharacterScanner)scanner, resume));
        }

        public IToken evaluate(ICharacterScanner scanner) {
            return SQLPartitionScanner.this.adaptToken(this.rule.evaluate((TPCharacterScanner)scanner));
        }
    }
}

