/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationPanelDescriptor;
import org.jkiss.utils.CommonUtils;

public class SQLPresentationDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sqlPresentation";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private final SQLEditorPresentation.ActivationType activationType;
    private final String toggleCommandId;
    private final List<SQLPresentationPanelDescriptor> panels = new ArrayList<SQLPresentationPanelDescriptor>();

    public SQLPresentationDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        String activationStr = config.getAttribute("activation");
        this.activationType = CommonUtils.isEmpty((String)activationStr) ? SQLEditorPresentation.ActivationType.HIDDEN : SQLEditorPresentation.ActivationType.valueOf(activationStr.toUpperCase(Locale.ENGLISH));
        this.toggleCommandId = config.getAttribute("toggleCommand");
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("panel");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement panelConfig = iConfigurationElementArray[n2];
            SQLPresentationPanelDescriptor presentationDescriptor = new SQLPresentationPanelDescriptor(panelConfig);
            this.panels.add(presentationDescriptor);
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public SQLEditorPresentation.ActivationType getActivationType() {
        return this.activationType;
    }

    public String getToggleCommandId() {
        return this.toggleCommandId;
    }

    public List<SQLPresentationPanelDescriptor> getPanels() {
        return this.panels;
    }

    public SQLEditorPresentation createPresentation() throws DBException {
        return (SQLEditorPresentation)this.implClass.createInstance(SQLEditorPresentation.class);
    }
}

