/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SQLEditorHandlerRenameFile
extends AbstractDataSourceHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = (IEditorPart)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActivePart((ExecutionEvent)event), IEditorPart.class);
        if (editor == null) {
            log.error((Object)"No active SQL editor");
            return null;
        }
        IFile file = EditorUtils.getFileFromInput((IEditorInput)editor.getEditorInput());
        if (file == null) {
            DBWorkbench.getPlatformUI().showError("Rename", "Can't rename - no source file");
            return null;
        }
        SQLEditorHandlerRenameFile.renameFile((IWorkbenchPart)editor, file, "SQL script");
        return null;
    }

    public static void renameFile(IWorkbenchPart editor, IFile file, String fileTitle) {
        int divPos;
        Shell shell = editor.getSite().getShell();
        String newName = EnterNameDialog.chooseName((Shell)shell, (String)("Rename " + fileTitle + " [" + file.getName() + "]"), (String)file.getName());
        if (newName == null) {
            return;
        }
        if (newName.indexOf(46) == -1 && (divPos = file.getName().lastIndexOf(46)) != -1) {
            newName = String.valueOf(newName) + file.getName().substring(divPos);
        }
        if (!newName.equals(file.getName())) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (editor instanceof IEditorPart) {
                ((IEditorPart)editor).doSave((IProgressMonitor)monitor);
            }
            String oldExtension = file.getFileExtension();
            try {
                IPath newFilePath = file.getParent().getFullPath().append(newName);
                file.move(newFilePath, true, (IProgressMonitor)monitor);
                file = file.getWorkspace().getRoot().getFile(newFilePath);
            }
            catch (CoreException e) {
                DBWorkbench.getPlatformUI().showError("Rename", "Error renaming file '" + file.getName() + "'", (Throwable)e);
            }
            final IFile newFile = file;
            String newExtension = file.getFileExtension();
            if ("sql".equals(newExtension) && !newExtension.equals(oldExtension)) {
                UIJob reopenJob = new UIJob("Reopen SQL script"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        FileEditorInput editorInput = new FileEditorInput(newFile);
                        IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
                        IEditorPart openEditor = activePage.findEditor((IEditorInput)editorInput);
                        if (openEditor != null) {
                            activePage.closeEditor(openEditor, true);
                            SQLEditorHandlerOpenEditor.openResource((IResource)newFile);
                        }
                        return Status.OK_STATUS;
                    }
                };
                reopenJob.schedule(250L);
            }
        }
    }
}

