/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceType {
    DB_INSTANCE("db-instance"),
    DB_PARAMETER_GROUP("db-parameter-group"),
    DB_SECURITY_GROUP("db-security-group"),
    DB_SNAPSHOT("db-snapshot"),
    DB_CLUSTER("db-cluster"),
    DB_CLUSTER_SNAPSHOT("db-cluster-snapshot"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceType> knownValues() {
        return Stream.of(SourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

