/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyEventSubscriptionRequestMarshaller
implements Marshaller<Request<ModifyEventSubscriptionRequest>, ModifyEventSubscriptionRequest> {
    public Request<ModifyEventSubscriptionRequest> marshall(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        SdkInternalList eventCategoriesList;
        SdkInternalList sourceIdsList;
        if (modifyEventSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyEventSubscriptionRequest, "AmazonRedshift");
        request.addParameter("Action", "ModifyEventSubscription");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyEventSubscriptionRequest.getSubscriptionName() != null) {
            request.addParameter("SubscriptionName", StringUtils.fromString((String)modifyEventSubscriptionRequest.getSubscriptionName()));
        }
        if (modifyEventSubscriptionRequest.getSnsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringUtils.fromString((String)modifyEventSubscriptionRequest.getSnsTopicArn()));
        }
        if (modifyEventSubscriptionRequest.getSourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)modifyEventSubscriptionRequest.getSourceType()));
        }
        if (!(sourceIdsList = (SdkInternalList)modifyEventSubscriptionRequest.getSourceIds()).isEmpty() || !sourceIdsList.isAutoConstruct()) {
            int sourceIdsListIndex = 1;
            for (String sourceIdsListValue : sourceIdsList) {
                if (sourceIdsListValue != null) {
                    request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringUtils.fromString((String)sourceIdsListValue));
                }
                ++sourceIdsListIndex;
            }
        }
        if (!(eventCategoriesList = (SdkInternalList)modifyEventSubscriptionRequest.getEventCategories()).isEmpty() || !eventCategoriesList.isAutoConstruct()) {
            int eventCategoriesListIndex = 1;
            for (String eventCategoriesListValue : eventCategoriesList) {
                if (eventCategoriesListValue != null) {
                    request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString((String)eventCategoriesListValue));
                }
                ++eventCategoriesListIndex;
            }
        }
        if (modifyEventSubscriptionRequest.getSeverity() != null) {
            request.addParameter("Severity", StringUtils.fromString((String)modifyEventSubscriptionRequest.getSeverity()));
        }
        if (modifyEventSubscriptionRequest.getEnabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean((Boolean)modifyEventSubscriptionRequest.getEnabled()));
        }
        return request;
    }
}

