/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hive.model.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.hive.model.HiveIndex;
import org.jkiss.dbeaver.ext.hive.model.HiveTable;
import org.jkiss.dbeaver.ext.hive.model.HiveTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class HiveTableManager
extends GenericTableManager
implements DBEObjectRenamer<GenericTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{HiveTableColumn.class, GenericUniqueKey.class, GenericTableForeignKey.class, HiveIndex.class};

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, GenericTableBase object, Class<? extends DBSObject> childType) throws DBException {
        if (childType == HiveTableColumn.class) {
            return object.getAttributes(monitor);
        }
        if (childType == HiveIndex.class) {
            return object.getIndexes(monitor);
        }
        return super.getChildObjects(monitor, (DBSObject)object, childType);
    }

    public boolean canDeleteObject(GenericTableBase object) {
        return !((HiveTable)object).isIndexTable();
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((GenericTableBase)command.getObject()).getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)((GenericTableBase)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((GenericTableBase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        GenericTableBase table = (GenericTableBase)command.getObject();
        if (table.getTableType().equals("INDEX_TABLE")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop index table", "DROP INDEX " + ((GenericTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
            return;
        }
        super.addObjectDeleteActions(monitor, executionContext, actions, command, options);
    }

    public void renameObject(DBECommandContext commandContext, GenericTableBase object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }
}

