/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.task;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskContext;
import org.jkiss.utils.CommonUtils;

public class DBTaskUtils {
    private static final Log log = Log.getLog(DBTaskUtils.class);
    public static final String TASK_VARIABLES = "taskVariables";
    public static final String TASK_CONTEXT = "taskContext";

    @NotNull
    public static Map<String, Object> getVariables(@NotNull DBTTask task) {
        Map<String, Object> state = task.getProperties();
        LinkedHashMap variables = (LinkedHashMap)state.get(TASK_VARIABLES);
        if (variables == null) {
            variables = new LinkedHashMap();
        }
        return variables;
    }

    public static void setVariables(@NotNull Map<String, Object> taskState, @Nullable Map<String, Object> variables) {
        if (!CommonUtils.isEmpty(variables)) {
            taskState.put(TASK_VARIABLES, variables);
        } else {
            taskState.remove(TASK_VARIABLES);
        }
    }

    public static DBTTaskContext extractContext(@NotNull DBCExecutionContext executionContext) {
        DBCTransactionManager txnManager;
        DBTTaskContext context = new DBTTaskContext();
        DBCExecutionContextDefaults defaults = executionContext.getContextDefaults();
        if (defaults != null) {
            Object defaultSchema;
            Object defaultCatalog = defaults.getDefaultCatalog();
            if (defaultCatalog != null) {
                context.setDefaultCatalog(defaultCatalog.getName());
            }
            if ((defaultSchema = defaults.getDefaultSchema()) != null) {
                context.setDefaultSchema(defaultSchema.getName());
            }
        }
        if ((txnManager = DBUtils.getTransactionManager(executionContext)) != null) {
            try {
                context.setAutoCommit(txnManager.isAutoCommit());
                DBPTransactionIsolation isolation = txnManager.getTransactionIsolation();
                if (isolation != null) {
                    context.setTransactionIsolation(isolation.getCode());
                }
            }
            catch (Throwable e) {
                log.debug(e);
            }
        }
        return context;
    }

    @Nullable
    public static DBTTaskContext loadTaskContext(@NotNull Map<String, Object> taskState) {
        Map contextMap = (Map)taskState.get(TASK_CONTEXT);
        if (contextMap == null) {
            return null;
        }
        DBTTaskContext context = new DBTTaskContext();
        context.setDefaultCatalog(CommonUtils.toString(contextMap.get("defaultCatalog"), null));
        context.setDefaultSchema(CommonUtils.toString(contextMap.get("defaultSchema"), null));
        context.setAutoCommit(CommonUtils.toBoolean(contextMap.get("autoCommit")));
        context.setTransactionIsolation(CommonUtils.toInt(contextMap.get("transactionIsolation"), (int)-1));
        return context;
    }

    public static void saveTaskContext(@NotNull Map<String, Object> taskState, @Nullable DBTTaskContext context) {
        if (context == null) {
            taskState.remove(TASK_CONTEXT);
            return;
        }
        LinkedHashMap<String, Object> taskContext = new LinkedHashMap<String, Object>();
        if (context.getDefaultCatalog() != null) {
            taskContext.put("defaultCatalog", context.getDefaultCatalog());
        }
        if (context.getDefaultSchema() != null) {
            taskContext.put("defaultSchema", context.getDefaultSchema());
        }
        taskContext.put("autoCommit", context.isAutoCommit());
        if (context.getTransactionIsolation() >= 0) {
            taskContext.put("transactionIsolation", context.getTransactionIsolation());
        }
        taskState.put(TASK_CONTEXT, taskContext);
    }

    public static void initFromContext(DBRProgressMonitor monitor, DBTTask task, DBCExecutionContext executionContext) throws DBException {
        DBTTaskContext context = DBTaskUtils.loadTaskContext(task.getProperties());
        if (context != null) {
            DBExecUtils.setExecutionContextDefaults(monitor, executionContext.getDataSource(), executionContext, context.getDefaultCatalog(), null, context.getDefaultSchema());
        }
    }

    public static boolean isTaskExists(DBTTask task) {
        if (task == null) {
            return false;
        }
        return task.getProject().getTaskManager().getTaskById(task.getId()) != null;
    }
}

