/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.SimpleExclusiveLock;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class JDBCRemoteInstance
implements DBSInstance {
    private static final Log log = Log.getLog(JDBCRemoteInstance.class);
    @NotNull
    protected final JDBCDataSource dataSource;
    @Nullable
    protected JDBCExecutionContext executionContext;
    @Nullable
    protected JDBCExecutionContext metaContext;
    @NotNull
    private final List<JDBCExecutionContext> allContexts = new ArrayList<JDBCExecutionContext>();
    private final DBPExclusiveResource exclusiveLock = new SimpleExclusiveLock();

    protected JDBCRemoteInstance(@NotNull DBRProgressMonitor monitor, @NotNull JDBCDataSource dataSource, boolean initContext) throws DBException {
        this.dataSource = dataSource;
        if (initContext) {
            this.initializeMainContext(monitor);
        }
    }

    protected JDBCRemoteInstance(@NotNull JDBCDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public String getName() {
        return this.dataSource.getName();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public String getDescription() {
        return null;
    }

    protected void initializeMainContext(@NotNull DBRProgressMonitor monitor) throws DBCException {
        if (this.executionContext == null) {
            this.executionContext = this.dataSource.createExecutionContext(this, this.getMainContextName());
            this.executionContext.connect(monitor, null, null, null, true);
        }
    }

    public JDBCExecutionContext initializeMetaContext(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.metaContext != null) {
            return this.metaContext;
        }
        if (!this.dataSource.getContainer().getDriver().isEmbedded() && this.dataSource.getContainer().getPreferenceStore().getBoolean("database.meta.separate.connection")) {
            this.metaContext = this.dataSource.createExecutionContext(this, this.getMetadataContextName());
            this.metaContext.connect(monitor, true, null, null, true);
            return this.metaContext;
        }
        return this.executionContext;
    }

    @NotNull
    protected String getMainContextName() {
        return "Main";
    }

    @NotNull
    protected String getMetadataContextName() {
        return "Metadata";
    }

    @Override
    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        JDBCExecutionContext context = this.dataSource.createExecutionContext(this, purpose);
        DBExecUtils.tryExecuteRecover(monitor, this.getDataSource(), monitor1 -> {
            try {
                context.connect((DBRProgressMonitor)monitor1, null, null, (JDBCExecutionContext)initFrom, true);
            }
            catch (DBCException e) {
                throw new InvocationTargetException(e);
            }
        });
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JDBCExecutionContext[] getAllContexts() {
        List<JDBCExecutionContext> list = this.allContexts;
        synchronized (list) {
            return this.allContexts.toArray(new JDBCExecutionContext[0]);
        }
    }

    @Override
    @NotNull
    public JDBCExecutionContext getDefaultContext(DBRProgressMonitor monitor, boolean meta) {
        return this.getDefaultContext(meta);
    }

    @NotNull
    public JDBCExecutionContext getDefaultContext(boolean meta) {
        if (this.metaContext != null && (meta || this.executionContext == null)) {
            return this.metaContext;
        }
        if (this.executionContext == null) {
            log.debug("No execution context within database instance");
            return null;
        }
        return this.executionContext;
    }

    @Override
    public void shutdown(DBRProgressMonitor monitor) {
        this.shutdown(monitor, false);
    }

    @Override
    @NotNull
    public DBPExclusiveResource getExclusiveLock() {
        return this.exclusiveLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor monitor, boolean keepMeta) {
        ArrayList<JDBCExecutionContext> ctxCopy;
        List<JDBCExecutionContext> list = this.allContexts;
        synchronized (list) {
            ctxCopy = new ArrayList<JDBCExecutionContext>(this.allContexts);
        }
        for (JDBCExecutionContext context : ctxCopy) {
            if (keepMeta && context == this.metaContext) continue;
            monitor.subTask("Close context '" + context.getContextName() + "'");
            context.close();
            monitor.worked(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContext(JDBCExecutionContext context) {
        List<JDBCExecutionContext> list = this.allContexts;
        synchronized (list) {
            this.allContexts.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeContext(JDBCExecutionContext context) {
        List<JDBCExecutionContext> list = this.allContexts;
        synchronized (list) {
            if (context == this.executionContext) {
                this.executionContext = null;
            }
            if (context == this.metaContext) {
                this.metaContext = null;
            }
            return this.allContexts.remove(context);
        }
    }
}

