/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class EpochTimeAttributeTransformer
implements DBDAttributeTransformer {
    private static final Log log = Log.getLog(EpochTimeAttributeTransformer.class);
    static final String PROP_UNIT = "unit";
    static final String ZONE_ID = "zoneId";

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "EpochTime", -1, DBPDataKind.DATETIME));
        EpochUnit unit = EpochUnit.milliseconds;
        try {
            unit = EpochUnit.valueOf(CommonUtils.toString((Object)options.get(PROP_UNIT)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Bad unit type");
        }
        attribute.setTransformHandler(new EpochValueHandler(attribute.getValueHandler(), unit, CommonUtils.toString((Object)options.get(ZONE_ID))));
    }

    private static enum EpochUnit {
        seconds{

            @Override
            Instant toInstant(long rawValue) {
                return Instant.ofEpochSecond(rawValue);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return SECONDS_FORMATTER;
            }

            @Override
            long toRawValue(Instant instant) {
                return instant.getEpochSecond();
            }
        }
        ,
        milliseconds{

            @Override
            Instant toInstant(long rawValue) {
                return Instant.ofEpochMilli(rawValue);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return MILLIS_FORMATTER;
            }

            @Override
            long toRawValue(Instant instant) {
                return instant.toEpochMilli();
            }
        }
        ,
        nanoseconds{

            @Override
            Instant toInstant(long rawValue) {
                return Instant.ofEpochSecond(rawValue / 1000000000L, rawValue % 1000000000L);
            }

            @Override
            DateTimeFormatter getFormatter() {
                return NANOS_FORMATTER;
            }

            @Override
            long toRawValue(Instant instant) {
                return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
            }
        };

        private static final DateTimeFormatter SECONDS_FORMATTER;
        private static final DateTimeFormatter MILLIS_FORMATTER;
        private static final DateTimeFormatter NANOS_FORMATTER;

        static {
            SECONDS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
            MILLIS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
            NANOS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnn", Locale.ENGLISH);
        }

        abstract Instant toInstant(long var1);

        abstract DateTimeFormatter getFormatter();

        abstract long toRawValue(Instant var1);
    }

    private static class EpochValueHandler
    extends ProxyValueHandler {
        private final EpochUnit unit;
        private final String zoneName;
        @Nullable
        private ZoneId zoneId;

        EpochValueHandler(DBDValueHandler target, EpochUnit unit, String zoneName) {
            super(target);
            this.unit = unit;
            this.zoneName = zoneName;
        }

        private ZoneId getZoneId() {
            if (this.zoneId != null) {
                return this.zoneId;
            }
            if (this.zoneName.isEmpty()) {
                return ZoneId.systemDefault();
            }
            this.zoneId = ZoneId.of(this.zoneName);
            return this.zoneId;
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            if (!(value instanceof Number)) {
                return DBValueFormatting.getDefaultValueDisplayString(value, format);
            }
            long rawValue = ((Number)value).longValue();
            Instant instant = this.unit.toInstant(rawValue);
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(instant, this.getZoneId());
            return this.unit.getFormatter().format(dateTime);
        }

        @Override
        @Nullable
        public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
            ZonedDateTime dateTime;
            if (!(object instanceof String)) {
                return super.getValueFromObject(session, type, object, copy, validateValue);
            }
            try {
                dateTime = ZonedDateTime.of(LocalDateTime.parse((String)object, this.unit.getFormatter()), this.getZoneId());
            }
            catch (DateTimeException dateTimeException) {
                return new DBCException("Incorrect zoneId");
            }
            return this.unit.toRawValue(Instant.from(dateTime));
        }
    }
}

