/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import org.jkiss.dbeaver.model.messages.ModelMessages;

public enum DBPDataSourcePermission {
    PERMISSION_EDIT_DATA("edit.data", ModelMessages.dbp_permission_edit_data_name, ModelMessages.dbp_permission_edit_data_description),
    PERMISSION_EDIT_METADATA("edit.meta", ModelMessages.dbp_permission_edit_metadata_name, ModelMessages.dbp_permission_edit_metadata_description),
    PERMISSION_EXECUTE_SCRIPTS("edit.execute", ModelMessages.dbp_permission_execute_scripts_name, ModelMessages.dbp_permission_execute_scripts_description),
    PERMISSION_IMPORT_DATA("import.data", ModelMessages.dbp_permission_import_data_name, ModelMessages.dbp_permission_import_data_description);

    private final String id;
    private final String label;
    private final String description;

    private DBPDataSourcePermission(String id, String label, String description) {
        this.id = id;
        this.label = label;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public static DBPDataSourcePermission getById(String id) {
        DBPDataSourcePermission[] dBPDataSourcePermissionArray = DBPDataSourcePermission.values();
        int n = dBPDataSourcePermissionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPDataSourcePermission permission = dBPDataSourcePermissionArray[n2];
            if (permission.id.equals(id)) {
                return permission;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Wrong permission id: " + id);
    }
}

