/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jkiss.code.Nullable;
import org.jkiss.lm.LMProduct;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;

public class LMUtils {
    private static final Logger log = Logger.getLogger("LMUtils");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat HR_DATE_FORMAT = new SimpleDateFormat("yyyy-MMM-dd");
    private static SecureRandom RND = new SecureRandom();
    private static short licenseCounter = (short)RND.nextInt(Short.MAX_VALUE);

    public static Date dateFromString(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(s);
        }
        catch (ParseException e) {
            log.log(Level.WARNING, "Error parsing date", e);
            return null;
        }
    }

    public static Map<String, Map<String, String>> parseConfig(InputStream is) throws IOException {
        LinkedHashMap<String, Map<String, String>> config = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> curSection = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                int divPos;
                if ((line = line.trim()).startsWith("#") || line.startsWith(";")) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    String sectionName = line.substring(1, line.length() - 2);
                    curSection = new LinkedHashMap();
                    config.put(sectionName, curSection);
                    continue;
                }
                if (curSection == null) {
                    curSection = new LinkedHashMap<String, String>();
                    config.put(null, curSection);
                }
                String propName = (divPos = line.indexOf(61)) == -1 ? line : line.substring(0, divPos);
                String propValue = divPos == -1 ? null : line.substring(divPos + 1);
                curSection.put(propName, propValue);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return config;
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static byte[] intToBytes(int x) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(x);
        return buffer.array();
    }

    public static byte[] shortToBytes(short x) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(x);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes, int offset) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, offset, 8);
        LMUtils.flipBuffer(buffer);
        return buffer.getLong();
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, offset, 4);
        LMUtils.flipBuffer(buffer);
        return buffer.getInt();
    }

    public static short bytesToShort(byte[] bytes, int offset) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.put(bytes, offset, 2);
        LMUtils.flipBuffer(buffer);
        return buffer.getShort();
    }

    private static void flipBuffer(Buffer buffer) {
        buffer.flip();
    }

    public static byte[] readEncryptedString(InputStream stream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            return LMUtils.readEncryptedString(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] readEncryptedString(Reader reader) throws IOException {
        StringBuilder result = new StringBuilder(4000);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    break;
                }
                if (line.startsWith("-") || line.startsWith("#")) continue;
                result.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Base64.decode((String)result.toString());
    }

    public static String generateLicenseId(LMProduct product) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(new Date());
        int dayOfYear = cal.get(6);
        int year = cal.get(1);
        int time = cal.get(11) * 60 + cal.get(12);
        short counter = LMUtils.getLicenseCounter();
        String licenseId = String.valueOf(product.getPrefix()) + "-" + LMUtils.getNumString(dayOfYear, 2) + LMUtils.getNumString(year, 3) + LMUtils.getNumString(time, 3) + "-" + LMUtils.getNumString(counter, 4);
        return CommonUtils.truncateString((String)licenseId, (int)16);
    }

    private static String getNumString(int value, int minDigits) {
        String str = Integer.toString(value, 35).toUpperCase(Locale.ENGLISH);
        while (str.length() < minDigits) {
            str = "Z" + str;
        }
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '0' || chars[i] == '0') {
                chars[i] = 90;
            }
            ++i;
        }
        return new String(chars);
    }

    private static synchronized short getLicenseCounter() {
        licenseCounter = (short)(licenseCounter + 1);
        return licenseCounter;
    }

    public static void copyStringBytes(byte[] data, int offset, String string, int length) {
        byte[] strData = string == null ? new byte[]{} : string.getBytes(StandardCharsets.UTF_8);
        System.arraycopy(strData, 0, data, offset, Math.min(length, strData.length));
        int i = strData.length;
        while (i < length) {
            data[offset + i] = 32;
            ++i;
        }
    }

    public static void copyDateBytes(byte[] data, int offset, Date date) {
        byte[] dateBytes = date == null ? new byte[8] : LMUtils.longToBytes(date.getTime());
        System.arraycopy(dateBytes, 0, data, offset, dateBytes.length);
    }

    @Nullable
    public static Date getDateFromBytes(byte[] data, int offset) {
        long time = LMUtils.bytesToLong(data, offset);
        return time == 0L ? null : new Date(time);
    }
}

