/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.security.Key;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.logging.Logger;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMSerializable;
import org.jkiss.lm.LMSerializeFormat;
import org.jkiss.lm.LMSubscriptionFormat;
import org.jkiss.lm.LMSubscriptionPeriod;
import org.jkiss.lm.LMUtils;

public class LMSubscription
implements LMSerializable {
    private static final Logger log = Logger.getLogger("LMSubscription");
    private LMSubscriptionFormat format;
    private String licenseId;
    private LMSubscriptionPeriod period;
    private int periodDays;
    private Date lastRenewDate;
    private Date expirationDate;
    private Date activationDate;
    private Date deactivationDate;
    private int totalRenewCount;
    private byte[] encoded;
    private boolean active;

    public LMSubscription(String licenseId, LMSubscriptionPeriod period, Date lastRenewDate, Date expirationDate, int totalRenewCount, boolean active) {
        this.format = LMSubscriptionFormat.STANDARD;
        this.licenseId = licenseId;
        this.period = period;
        this.lastRenewDate = lastRenewDate;
        this.expirationDate = expirationDate;
        this.totalRenewCount = totalRenewCount;
        this.active = active;
    }

    public LMSubscription(byte[] encryptedData, Key key) throws LMException {
        this.encoded = encryptedData;
        byte[] data = LMEncryption.decrypt(encryptedData, key);
        int offset = 0;
        this.format = LMSubscriptionFormat.STANDARD;
        try {
            this.format = LMSubscriptionFormat.valueOf(data[offset]);
        }
        catch (Exception exception) {
            log.warning("Unsupported license format: " + data[offset]);
        }
        ++offset;
        if (data.length != this.format.getEncryptedLength()) {
            throw new LMException("Bad " + this.format + " subscription length (" + data.length + ")");
        }
        this.licenseId = new String(data, offset, 16).trim();
        offset += 16;
        this.period = LMSubscriptionPeriod.getById((char)data[offset++]);
        this.periodDays = LMUtils.bytesToInt(data, offset);
        this.lastRenewDate = LMUtils.getDateFromBytes(data, offset += 4);
        this.expirationDate = LMUtils.getDateFromBytes(data, offset += 8);
        this.activationDate = LMUtils.getDateFromBytes(data, offset += 8);
        this.deactivationDate = LMUtils.getDateFromBytes(data, offset += 8);
        this.totalRenewCount = LMUtils.bytesToInt(data, offset += 8);
        offset += 4;
        this.active = data[offset++] != 0;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public LMSubscriptionPeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(LMSubscriptionPeriod period) {
        this.period = period;
    }

    public int getPeriodDays() {
        return this.periodDays;
    }

    public void setPeriodDays(int periodDays) {
        this.periodDays = periodDays;
    }

    public Date getLastRenewDate() {
        return this.lastRenewDate;
    }

    public void setLastRenewDate(Date lastRenewDate) {
        this.lastRenewDate = lastRenewDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(Date activationDate) {
        this.activationDate = activationDate;
    }

    public Date getDeactivationDate() {
        return this.deactivationDate;
    }

    public void setDeactivationDate(Date deactivationDate) {
        this.deactivationDate = deactivationDate;
    }

    public int getTotalRenewCount() {
        return this.totalRenewCount;
    }

    public void setTotalRenewCount(int totalRenewCount) {
        this.totalRenewCount = totalRenewCount;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public LMSerializeFormat getFormat() {
        return this.format;
    }

    @Override
    public byte[] getData() {
        byte[] data = new byte[this.format.getEncryptedLength()];
        int offset = 0;
        data[offset] = this.format.getId();
        LMUtils.copyStringBytes(data, ++offset, this.licenseId, 16);
        offset += 16;
        data[offset++] = (byte)this.period.getId();
        System.arraycopy(LMUtils.intToBytes(this.periodDays), 0, data, offset, 4);
        LMUtils.copyDateBytes(data, offset += 4, this.lastRenewDate);
        LMUtils.copyDateBytes(data, offset += 8, this.expirationDate);
        LMUtils.copyDateBytes(data, offset += 8, this.activationDate);
        LMUtils.copyDateBytes(data, offset += 8, this.deactivationDate);
        System.arraycopy(LMUtils.intToBytes(this.totalRenewCount), 0, data, offset += 8, 4);
        offset += 4;
        data[offset++] = (byte)(this.active ? 1 : 0);
        return data;
    }

    public boolean isExpired() {
        LocalDateTime curDate = LocalDateTime.now();
        LocalDateTime expDate = this.expirationDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return curDate.isAfter(expDate);
    }
}

