/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.execute;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDataReceiverInteractive;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.local.StatResultSet;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.runtime.sql.SQLResultsConsumer;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.utils.CommonUtils;

public class SQLQueryJob
extends DataSourceJob {
    private static final Log log = Log.getLog(SQLQueryJob.class);
    public static final Object STATS_RESULTS = new Object();
    private final DBSDataContainer dataContainer;
    private final List<SQLScriptElement> queries;
    private final SQLScriptContext scriptContext;
    private final SQLResultsConsumer resultsConsumer;
    private final SQLQueryListener listener;
    private final IWorkbenchPartSite partSite;
    private DBDDataFilter dataFilter;
    private boolean connectionInvalidated = false;
    private SQLScriptCommitType commitType;
    private SQLScriptErrorHandling errorHandling;
    private boolean fetchResultSets;
    private long rsOffset;
    private long rsMaxRows;
    private DBCStatement curStatement;
    private final List<DBCResultSet> curResultSets = new ArrayList<DBCResultSet>();
    private Throwable lastError = null;
    private DBCStatistics statistics;
    private int fetchResultSetNumber;
    private int resultSetNumber;
    private SQLQuery lastGoodQuery;
    private boolean skipConfirmation;
    private int fetchSize;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;

    public SQLQueryJob(@NotNull IWorkbenchPartSite partSite, @NotNull String name, @NotNull DBCExecutionContext executionContext, @Nullable DBSDataContainer dataContainer, @NotNull List<SQLScriptElement> queries, @NotNull SQLScriptContext scriptContext, @Nullable SQLResultsConsumer resultsConsumer, @Nullable SQLQueryListener listener) {
        super(name, executionContext);
        this.dataContainer = dataContainer;
        this.partSite = partSite;
        this.queries = queries;
        this.scriptContext = scriptContext;
        this.resultsConsumer = resultsConsumer;
        this.listener = listener;
        DBPPreferenceStore preferenceStore = this.getDataSourceContainer().getPreferenceStore();
        this.commitType = SQLScriptCommitType.valueOf((String)preferenceStore.getString("script.commit.type"));
        this.errorHandling = SQLScriptErrorHandling.valueOf((String)preferenceStore.getString("script.error.handling"));
        this.fetchResultSets = queries.size() == 1 || preferenceStore.getBoolean("script.fetch.resultset");
        this.rsMaxRows = preferenceStore.getInt("resultset.maxrows");
    }

    public void setFetchResultSets(boolean fetchResultSets) {
        this.fetchResultSets = fetchResultSets;
    }

    public SQLScriptElement getLastQuery() {
        return this.queries.isEmpty() ? null : this.queries.get(0);
    }

    public SQLScriptElement getLastGoodQuery() {
        return this.lastGoodQuery;
    }

    public DBCStatement getCurrentStatement() {
        return this.curStatement;
    }

    private boolean hasLimits() {
        return this.rsOffset >= 0L && this.rsMaxRows > 0L;
    }

    public void setResultSetLimit(long offset, long maxRows) {
        this.rsOffset = offset;
        this.rsMaxRows = maxRows;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(DBRProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean executeSingleQuery(@NotNull DBCSession session, @NotNull SQLScriptElement element, boolean fireEvents) {
        SQLQueryResult curResult;
        SQLQuery originalQuery;
        block40: {
            if (element instanceof SQLControlCommand) {
                try {
                    return this.scriptContext.executeControlCommand((SQLControlCommand)element);
                }
                catch (Throwable e) {
                    if (!(e instanceof DBException)) {
                        log.error((Object)"Unexpected error while processing SQL command", e);
                    }
                    this.lastError = e;
                    return false;
                }
            }
            SQLQuery sqlQuery = (SQLQuery)element;
            this.lastError = null;
            if (!this.skipConfirmation && this.getDataSourceContainer().getConnectionConfiguration().getConnectionType().isConfirmExecute() && !SQLSemanticProcessor.isSelectQuery((String)element.getText())) {
                int confirmResult = this.confirmQueryExecution((SQLQuery)element, this.queries.size() > 1);
                switch (confirmResult) {
                    case 3: {
                        return true;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        this.skipConfirmation = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            DBCExecutionContext executionContext = this.getExecutionContext();
            DBPDataSource dataSource = executionContext.getDataSource();
            originalQuery = sqlQuery;
            DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(sqlQuery, this.resultSetNumber);
            try {
                if (dataReceiver instanceof DBDDataReceiverInteractive) {
                    ((DBDDataReceiverInteractive)dataReceiver).setDataReceivePaused(true);
                }
                if (!this.scriptContext.fillQueryParameters((SQLQuery)element)) {
                    return false;
                }
            }
            finally {
                if (dataReceiver instanceof DBDDataReceiverInteractive) {
                    ((DBDDataReceiverInteractive)dataReceiver).setDataReceivePaused(false);
                }
            }
            long startTime = System.currentTimeMillis();
            boolean startQueryAlerted = false;
            String queryText = originalQuery.getText();
            if (this.dataFilter != null && this.dataFilter.hasFilters() && dataSource instanceof SQLDataSource) {
                String filteredQueryText = ((SQLDataSource)dataSource).getSQLDialect().addFiltersToQuery(dataSource, queryText, this.dataFilter);
                sqlQuery = new SQLQuery(executionContext.getDataSource(), filteredQueryText, sqlQuery);
            } else {
                sqlQuery = new SQLQuery(executionContext.getDataSource(), queryText, sqlQuery);
            }
            curResult = new SQLQueryResult(sqlQuery);
            if (this.rsOffset > 0L) {
                curResult.setRowOffset(Long.valueOf(this.rsOffset));
            }
            try {
                try {
                    this.closeStatement();
                    if (!this.connectionInvalidated && dataSource.getContainer().getPreferenceStore().getBoolean("statement.invalidate.before.execute")) {
                        executionContext.invalidateContext(session.getProgressMonitor(), true);
                        this.connectionInvalidated = true;
                    }
                    this.statistics.setQueryText(sqlQuery.getText());
                    if (fireEvents && this.listener != null) {
                        try {
                            this.listener.onStartQuery(session, sqlQuery);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                        startQueryAlerted = true;
                    }
                    startTime = System.currentTimeMillis();
                    SQLQuery execStatement = sqlQuery;
                    DBExecUtils.tryExecuteRecover((Object)session, (DBPDataSource)session.getDataSource(), param -> {
                        try {
                            long execStartTime = System.currentTimeMillis();
                            this.executeStatement(session, execStatement, execStartTime, curResult);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (Throwable ex) {
                    if (!(ex instanceof DBException)) {
                        log.error((Object)"Unexpected error while processing SQL", ex);
                    }
                    curResult.setError(ex);
                    this.lastError = ex;
                    curResult.setQueryTime(System.currentTimeMillis() - startTime);
                    if (fireEvents && this.listener != null && startQueryAlerted) {
                        try {
                            this.listener.onEndQuery(session, curResult);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                    this.scriptContext.clearStatementContext();
                    break block40;
                }
            }
            catch (Throwable throwable) {
                curResult.setQueryTime(System.currentTimeMillis() - startTime);
                if (fireEvents && this.listener != null && startQueryAlerted) {
                    try {
                        this.listener.onEndQuery(session, curResult);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                this.scriptContext.clearStatementContext();
                throw throwable;
            }
            curResult.setQueryTime(System.currentTimeMillis() - startTime);
            if (fireEvents && this.listener != null && startQueryAlerted) {
                try {
                    this.listener.onEndQuery(session, curResult);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            this.scriptContext.clearStatementContext();
        }
        if (curResult.getError() != null && this.errorHandling != SQLScriptErrorHandling.IGNORE) {
            return false;
        }
        this.lastGoodQuery = originalQuery;
        return true;
    }

    private void executeStatement(@NotNull DBCSession session, SQLQuery sqlQuery, long startTime, SQLQueryResult curResult) throws DBCException {
        AbstractExecutionSource source = new AbstractExecutionSource(this.dataContainer, session.getExecutionContext(), (Object)this.partSite.getPart(), (Object)sqlQuery);
        DBCStatement dbcStatement = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.SCRIPT, (SQLQuery)sqlQuery, (long)this.rsOffset, (long)this.rsMaxRows);
        DBExecUtils.setStatementFetchSize((DBCStatement)dbcStatement, (long)this.rsOffset, (long)this.rsMaxRows, (int)this.fetchSize);
        this.curStatement = dbcStatement;
        int statementTimeout = this.getDataSourceContainer().getPreferenceStore().getInt("statement.timeout");
        if (statementTimeout > 0) {
            try {
                dbcStatement.setStatementTimeout(statementTimeout);
            }
            catch (Throwable e) {
                log.debug((Object)("Can't set statement timeout:" + e.getMessage()));
            }
        }
        try {
            session.getProgressMonitor().subTask("Execute query");
            boolean hasResultSet = dbcStatement.executeStatement();
            this.statistics.addExecuteTime(System.currentTimeMillis() - startTime);
            this.statistics.addStatementsCount();
            curResult.setHasResultSet(hasResultSet);
            long updateCount = -1L;
            while (true) {
                if ((this.fetchResultSetNumber < 0 || this.fetchResultSetNumber == this.resultSetNumber) && hasResultSet && this.fetchResultSets) {
                    DBCResultSet resultSet = dbcStatement.openResultSet();
                    if (resultSet == null) {
                        break;
                    }
                    DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(sqlQuery, this.resultSetNumber);
                    if (dataReceiver != null) {
                        hasResultSet = this.fetchQueryData(session, resultSet, curResult, curResult.addExecuteResult(true), dataReceiver, true);
                    }
                }
                if (!hasResultSet) {
                    try {
                        updateCount = dbcStatement.getUpdateRowCount();
                        if (updateCount >= 0L) {
                            curResult.addExecuteResult(false).setUpdateCount(Long.valueOf(updateCount));
                            this.statistics.addRowsUpdated(updateCount);
                        }
                    }
                    catch (DBCException e) {
                        log.warn((Object)"Can't obtain update count", (Throwable)e);
                    }
                }
                if (hasResultSet && this.fetchResultSets) {
                    this.fetchResultSetNumber = ++this.resultSetNumber;
                }
                if (!hasResultSet && updateCount < 0L) {
                    break;
                }
                if (!session.getDataSource().getInfo().supportsMultipleResults()) break;
                try {
                    hasResultSet = dbcStatement.nextResults();
                }
                catch (DBCException e) {
                    if (session.getDataSource().getInfo().isMultipleResultsFetchBroken()) {
                        log.error((Object)e);
                        hasResultSet = dbcStatement.nextResults();
                    }
                    throw e;
                }
                updateCount = hasResultSet ? -1 : 0;
            }
        }
        finally {
            try {
                curResult.addWarnings(dbcStatement.getStatementWarnings());
            }
            catch (Throwable e) {
                log.warn((Object)"Can't read execution warnings", e);
            }
            if (!this.keepStatementOpen()) {
                this.closeStatement();
            }
        }
    }

    private void showExecutionResult(DBCSession session) {
        if (this.statistics.getStatementsCount() > 1 || this.resultSetNumber == 0) {
            SQLQuery query = new SQLQuery(session.getDataSource(), "", -1, -1);
            if (this.queries.size() == 1) {
                query.setText(this.queries.get(0).getText());
            }
            query.setData(STATS_RESULTS);
            DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(query, this.resultSetNumber);
            if (dataReceiver != null) {
                try {
                    this.fetchExecutionResult(session, dataReceiver, query);
                }
                catch (DBCException e) {
                    log.error((Object)"Error generating execution result stats", (Throwable)e);
                }
            }
        }
    }

    private void fetchExecutionResult(@NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @NotNull SQLQuery query) throws DBCException {
        StatResultSet fakeResultSet = new StatResultSet(session, this.curStatement);
        SQLQueryResult resultInfo = new SQLQueryResult(query);
        SQLQueryResult.ExecuteResult executeResult = resultInfo.addExecuteResult(true);
        if (this.statistics.getStatementsCount() > 1) {
            fakeResultSet.addColumn("Queries", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Updated Rows", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Execute time (ms)", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Fetch time (ms)", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Total time (ms)", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Finish time", DBPDataKind.DATETIME);
            fakeResultSet.addRow(new Object[]{this.statistics.getStatementsCount(), this.statistics.getRowsUpdated(), this.statistics.getExecuteTime(), this.statistics.getFetchTime(), this.statistics.getTotalTime(), new Date()});
            executeResult.setResultSetName("Statistics");
        } else {
            long updateCount = this.statistics.getRowsUpdated();
            if (updateCount >= 0L) {
                fakeResultSet.addColumn("Updated Rows", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Query", DBPDataKind.STRING);
                fakeResultSet.addColumn("Finish time", DBPDataKind.DATETIME);
                fakeResultSet.addRow(new Object[]{updateCount, query.getText(), new Date()});
            } else {
                fakeResultSet.addColumn("Result", DBPDataKind.NUMERIC);
            }
            executeResult.setResultSetName("Result");
        }
        this.fetchQueryData(session, (DBCResultSet)fakeResultSet, resultInfo, executeResult, dataReceiver, false);
    }

    private boolean fetchQueryData(DBCSession session, DBCResultSet resultSet, SQLQueryResult result, SQLQueryResult.ExecuteResult executeResult, DBDDataReceiver dataReceiver, boolean updateStatistics) throws DBCException {
        if (dataReceiver == null) {
            return false;
        }
        if (resultSet == null) {
            return false;
        }
        boolean keepCursor = this.keepStatementOpen();
        if (keepCursor) {
            this.curResultSets.add(resultSet);
        }
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.subTask("Fetch result set");
        DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
        dataReceiver.fetchStart(session, resultSet, this.rsOffset, this.rsMaxRows);
        try {
            String sourceName = null;
            if (result != null) {
                String queryTitle = result.getStatement().getQueryTitle();
                if (!CommonUtils.isEmpty((String)queryTitle)) {
                    sourceName = queryTitle;
                } else {
                    DBCResultSetMetaData rsMeta = resultSet.getMeta();
                    for (DBCAttributeMetaData attr : rsMeta.getAttributes()) {
                        String entityName = attr.getEntityName();
                        if (CommonUtils.isEmpty((String)entityName)) continue;
                        if (sourceName == null) {
                            sourceName = entityName;
                            continue;
                        }
                        if (sourceName.equals(entityName)) continue;
                        sourceName = String.valueOf(sourceName) + "(+)";
                        break;
                    }
                    if (CommonUtils.isEmpty((String)sourceName)) {
                        try {
                            sourceName = resultSet.getResultSetName();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (CommonUtils.isEmpty((String)sourceName)) {
                    sourceName = "Result";
                }
                executeResult.setResultSetName(sourceName);
            }
            long fetchStartTime = System.currentTimeMillis();
            while (!(this.hasLimits() && fetchProgress.isMaxRowsFetched(this.rsMaxRows) || fetchProgress.isCanceled() || !resultSet.nextRow())) {
                dataReceiver.fetchRow(session, resultSet);
                fetchProgress.monitorRowFetch();
            }
            if (updateStatistics) {
                this.statistics.addFetchTime(System.currentTimeMillis() - fetchStartTime);
            }
        }
        finally {
            if (!keepCursor) {
                try {
                    resultSet.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Error while closing resultset", e);
                }
            }
            try {
                dataReceiver.fetchEnd(session, resultSet);
            }
            catch (Throwable e) {
                log.error((Object)"Error while handling end of result set fetch", e);
            }
            dataReceiver.close();
        }
        if (result != null) {
            executeResult.setRowCount(Long.valueOf(fetchProgress.getRowCount()));
        }
        if (updateStatistics) {
            this.statistics.setRowsFetched(fetchProgress.getRowCount());
        }
        monitor.subTask(String.valueOf(fetchProgress.getRowCount()) + " rows fetched");
        return true;
    }

    private boolean keepStatementOpen() {
        return this.queries.size() == 1 && this.getDataSourceContainer().getPreferenceStore().getBoolean("keep.statement.open");
    }

    private void closeStatement() {
        if (this.curStatement != null) {
            try {
                for (DBCResultSet resultSet : this.curResultSets) {
                    resultSet.close();
                }
            }
            finally {
                block15: {
                    this.curResultSets.clear();
                    try {
                        try {
                            this.curStatement.close();
                        }
                        catch (Throwable e) {
                            log.error((Object)"Error closing statement", e);
                            this.curStatement = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.curStatement = null;
                        throw throwable;
                    }
                    this.curStatement = null;
                }
            }
        }
    }

    public void extractData(@NotNull DBCSession session, @NotNull SQLScriptElement query, int resultNumber) throws DBCException {
        query.reset();
        this.statistics = new DBCStatistics();
        this.resultSetNumber = resultNumber;
        session.getProgressMonitor().subTask(CommonUtils.truncateString((String)query.getText(), (int)512));
        boolean result = this.executeSingleQuery(session, query, true);
        if (!result && this.lastError != null) {
            if (this.lastError instanceof DBCException) {
                throw (DBCException)this.lastError;
            }
            throw new DBCException(this.lastError, this.getExecutionContext().getDataSource());
        }
        if (result && this.statistics.getStatementsCount() > 0) {
            this.showExecutionResult(session);
        }
    }

    public void setDataFilter(DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    public void setFetchResultSetNumber(int fetchResultSetNumber) {
        this.fetchResultSetNumber = fetchResultSetNumber;
    }

    public void closeJob() {
        this.closeStatement();
    }

    private int confirmQueryExecution(final @NotNull SQLQuery query, final boolean scriptMode) {
        final DBPConnectionType connectionType = this.getDataSourceContainer().getConnectionConfiguration().getConnectionType();
        return (Integer)new UITask<Integer>(){

            protected Integer runTask() {
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(UIUtils.getActiveWorkbenchShell(), "Confirm query execution", null, "You are in '" + connectionType.getName() + "' connection.\nDo you confirm query execution?", 4, ConfirmationDialog.getButtonLabels((int)6), 0, "Do not ask for " + connectionType.getName() + " connections", false){

                    protected boolean isResizable() {
                        return true;
                    }

                    protected IDialogSettings getDialogBoundsSettings() {
                        return UIUtils.getDialogSettings((String)"DBeaver.SQLQueryConfirmDialog");
                    }

                    protected void createDialogAndButtonArea(Composite parent) {
                        this.dialogArea = this.createDialogArea(parent);
                        if (this.dialogArea.getLayoutData() instanceof GridData) {
                            ((GridData)this.dialogArea.getLayoutData()).grabExcessVerticalSpace = false;
                        }
                        Text messageText = new Text(parent, 2634);
                        messageText.setText(query.getText());
                        GridData gd = new GridData(1808);
                        gd.heightHint = UIUtils.getFontHeight((Control)messageText) * 4 + 10;
                        gd.horizontalSpan = 2;
                        messageText.setLayoutData((Object)gd);
                        this.buttonBar = this.createButtonBar(parent);
                        1.applyDialogFont((Control)parent);
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
                        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
                        if (scriptMode) {
                            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
                            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                        }
                    }
                };
                int result = dialog.open();
                if (dialog.getToggleState()) {
                    connectionType.setConfirmExecute(false);
                    DBWorkbench.getPlatform().getDataSourceProviderRegistry().saveConnectionTypes();
                }
                return result;
            }
        }.execute();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;
        }
        int[] nArray = new int[DBPPlatformUI.UserResponse.values().length];
        try {
            nArray[DBPPlatformUI.UserResponse.CANCEL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE_ALL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.RETRY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.STOP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse = nArray;
        return nArray;
    }
}

