/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.utils.CommonUtils;

public class JDBCURL {
    private static final char URL_GROUP_START = '{';
    private static final char URL_GROUP_END = '}';
    private static final char URL_OPTIONAL_START = '[';
    private static final char URL_OPTIONAL_END = ']';

    public static String generateUrlByTemplate(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        try {
            String urlTemplate = driver.getSampleURL();
            if (CommonUtils.isEmptyTrimmed((String)urlTemplate)) {
                return connectionInfo.getUrl();
            }
            MetaURL metaURL = JDBCURL.parseSampleURL(urlTemplate);
            StringBuilder url = new StringBuilder();
            Iterator<String> iterator = metaURL.getUrlComponents().iterator();
            while (iterator.hasNext()) {
                String component;
                String newComponent = component = iterator.next();
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                    newComponent = newComponent.replace(JDBCURL.makePropPattern("host"), connectionInfo.getHostName());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                    newComponent = newComponent.replace(JDBCURL.makePropPattern("port"), connectionInfo.getHostPort());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
                    newComponent = newComponent.replace(JDBCURL.makePropPattern("server"), connectionInfo.getServerName());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                    newComponent = newComponent.replace(JDBCURL.makePropPattern("database"), connectionInfo.getDatabaseName());
                    newComponent = newComponent.replace(JDBCURL.makePropPattern("folder"), connectionInfo.getDatabaseName());
                    newComponent = newComponent.replace(JDBCURL.makePropPattern("file"), connectionInfo.getDatabaseName());
                }
                newComponent = newComponent.replace(JDBCURL.makePropPattern("user"), CommonUtils.notEmpty((String)connectionInfo.getUserName()));
                if ((newComponent = newComponent.replace(JDBCURL.makePropPattern("password"), CommonUtils.notEmpty((String)connectionInfo.getUserPassword()))).startsWith("[")) {
                    if (newComponent.equals(component)) continue;
                    url.append(newComponent.substring(1, newComponent.length() - 1));
                    continue;
                }
                url.append(newComponent);
            }
            return url.toString();
        }
        catch (DBException e) {
            JDBCDataSourceProvider.log.error(e);
            return null;
        }
    }

    private static String makePropPattern(String prop) {
        return "{" + prop + "}";
    }

    public static MetaURL parseSampleURL(String sampleURL) throws DBException {
        int divPos;
        MetaURL metaURL = new MetaURL();
        int offsetPos = 0;
        while ((divPos = sampleURL.indexOf(123, offsetPos)) != -1) {
            int divPos2 = sampleURL.indexOf(125, divPos);
            if (divPos2 == -1) {
                throw new DBException("Bad sample URL: " + sampleURL);
            }
            String propName = sampleURL.substring(divPos + 1, divPos2);
            boolean isOptional = false;
            int optDiv1 = sampleURL.lastIndexOf(91, divPos);
            int optDiv1c = sampleURL.lastIndexOf(93, divPos);
            int optDiv2 = sampleURL.indexOf(93, divPos2);
            int optDiv2c = sampleURL.indexOf(91, divPos2);
            if (!(optDiv1 == -1 || optDiv2 == -1 || optDiv1c != -1 && optDiv1c >= optDiv1 || optDiv2c != -1 && optDiv2c <= optDiv2)) {
                divPos = optDiv1;
                divPos2 = optDiv2;
                isOptional = true;
            }
            if (divPos > offsetPos) {
                metaURL.urlComponents.add(sampleURL.substring(offsetPos, divPos));
            }
            metaURL.urlComponents.add(sampleURL.substring(divPos, divPos2 + 1));
            metaURL.availableProperties.add(propName);
            if (!isOptional) {
                metaURL.requiredProperties.add(propName);
            }
            offsetPos = divPos2 + 1;
        }
        if (offsetPos < sampleURL.length()) {
            metaURL.urlComponents.add(sampleURL.substring(offsetPos));
        }
        return metaURL;
    }

    public static class MetaURL {
        private List<String> urlComponents = new ArrayList<String>();
        private Set<String> availableProperties = new HashSet<String>();
        private Set<String> requiredProperties = new HashSet<String>();

        public List<String> getUrlComponents() {
            return this.urlComponents;
        }

        public Set<String> getAvailableProperties() {
            return this.availableProperties;
        }

        public Set<String> getRequiredProperties() {
            return this.requiredProperties;
        }
    }
}

