/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPToolTipObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBPositiveNumberTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public abstract class AbstractAttribute
implements DBSAttributeBase,
DBPToolTipObject {
    protected String name;
    protected int valueType;
    protected long maxLength;
    protected boolean required;
    protected boolean autoGenerated;
    protected Integer scale;
    protected Integer precision;
    protected String typeName;
    protected int ordinalPosition;

    protected AbstractAttribute() {
    }

    protected AbstractAttribute(DBSAttributeBase source) {
        this.name = source.getName();
        this.valueType = source.getTypeID();
        this.maxLength = source.getMaxLength();
        this.scale = source.getScale();
        this.precision = source.getPrecision();
        this.required = source.isRequired();
        this.autoGenerated = source.isAutoGenerated();
        this.typeName = source.getTypeName();
        this.ordinalPosition = source.getOrdinalPosition();
    }

    protected AbstractAttribute(String name, String typeName, int valueType, int ordinalPosition, long maxLength, Integer scale, Integer precision, boolean required, boolean autoGenerated) {
        this.name = name;
        this.valueType = valueType;
        this.maxLength = maxLength;
        this.scale = scale;
        this.precision = precision;
        this.required = required;
        this.autoGenerated = autoGenerated;
        this.typeName = typeName;
        this.ordinalPosition = ordinalPosition;
    }

    @Override
    @Property(viewable=true, order=10, valueTransformer=DBObjectNameCaseTransformer.class)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String columnName) {
        this.name = columnName;
    }

    @Override
    @Property(viewable=true, order=15)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    @Override
    @Property(viewable=true, order=20)
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getFullTypeName() {
        return DBUtils.getFullTypeName(this);
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public int getTypeID() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    @Override
    @Property(viewable=true, order=40)
    public long getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    @Property(viewable=false, valueRenderer=DBPositiveNumberTransformer.class, order=41)
    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    @Override
    @Property(viewable=false, valueRenderer=DBPositiveNumberTransformer.class, order=42)
    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Override
    @Property(viewable=true, order=50)
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    @Property(viewable=true, order=55)
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @Override
    public String getObjectToolTip() {
        return DBUtils.getFullTypeName(this);
    }

    public String toString() {
        return String.valueOf(this.name) + ", type=" + this.typeName + ", pos=" + this.ordinalPosition;
    }
}

