/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.wmi.Activator;
import org.jkiss.dbeaver.ext.wmi.WMIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class WMIConnectionPage
extends ConnectionPageAbstract {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_NAMESPACE = "root/cimv2";
    private Text domainText;
    private Text hostText;
    private Combo namespaceCombo;
    private Combo localeCombo;
    private Text usernameText;
    private Text passwordText;
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/wmi_logo.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        ModifyListener textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WMIConnectionPage.this.evaluateURL();
            }
        };
        Composite addrGroup = new Composite(composite, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        addrGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        Label hostLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)WMIMessages.wmi_connection_page_label_host);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        Label domainLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)WMIMessages.wmi_connection_page_label_domain);
        domainLabel.setLayoutData((Object)new GridData(128));
        this.domainText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.domainText.setLayoutData((Object)gd);
        this.domainText.addModifyListener(textListener);
        Label namespaceLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)WMIMessages.wmi_connection_page_label_namespace);
        namespaceLabel.setLayoutData((Object)new GridData(128));
        this.namespaceCombo = new Combo(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.namespaceCombo.setLayoutData((Object)gd);
        this.namespaceCombo.addModifyListener(textListener);
        Label divLabel = new Label(addrGroup, 266);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 4;
        divLabel.setLayoutData((Object)gd);
        Label usernameLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)WMIMessages.wmi_connection_page_label_user);
        usernameLabel.setLayoutData((Object)new GridData(128));
        this.usernameText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(textListener);
        UIUtils.createEmptyLabel((Composite)addrGroup, (int)2, (int)1);
        Label passwordLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)WMIMessages.wmi_connection_page_label_password);
        passwordLabel.setLayoutData((Object)new GridData(128));
        this.passwordText = new Text(addrGroup, 0x400800);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        this.createPasswordControls(addrGroup, this.passwordText, 2);
        this.setControl((Control)addrGroup);
    }

    public boolean isComplete() {
        return this.hostText != null && this.namespaceCombo != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && !CommonUtils.isEmpty((String)this.namespaceCombo.getText());
    }

    public void loadSettings() {
        DBPDataSourceContainer activeDataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration connectionInfo = activeDataSource.getConnectionConfiguration();
        if (connectionInfo.getHostName() == null) {
            connectionInfo.setHostName(DEFAULT_HOST);
        }
        if (connectionInfo.getDatabaseName() == null) {
            connectionInfo.setDatabaseName(DEFAULT_NAMESPACE);
        }
        if (this.hostText != null) {
            this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
        }
        if (this.domainText != null) {
            this.domainText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        }
        if (this.usernameText != null) {
            this.usernameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
        if (this.namespaceCombo != null) {
            this.namespaceCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.domainText != null) {
            connectionInfo.setServerName(this.domainText.getText().trim());
        }
        if (this.namespaceCombo != null) {
            connectionInfo.setDatabaseName(this.namespaceCombo.getText().trim());
        }
        if (this.usernameText != null) {
            connectionInfo.setUserName(this.usernameText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        super.saveSettings(dataSource);
    }

    private void evaluateURL() {
        this.site.updateButtons();
    }
}

