/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableIndexColumn;
import org.jkiss.dbeaver.model.meta.Property;

public class OracleTableIndexColumn
extends AbstractTableIndexColumn {
    private OracleTableIndex index;
    private OracleTableColumn tableColumn;
    private int ordinalPosition;
    private boolean ascending;
    private String columnExpression;

    public OracleTableIndexColumn(OracleTableIndex index, OracleTableColumn tableColumn, int ordinalPosition, boolean ascending, String columnExpression) {
        this.index = index;
        this.tableColumn = tableColumn;
        this.ordinalPosition = ordinalPosition;
        this.ascending = ascending;
        this.columnExpression = columnExpression;
    }

    OracleTableIndexColumn(OracleTableIndex toIndex, OracleTableIndexColumn source) {
        this.index = toIndex;
        this.tableColumn = source.tableColumn;
        this.ordinalPosition = source.ordinalPosition;
        this.ascending = source.ascending;
        this.columnExpression = source.columnExpression;
    }

    @NotNull
    public OracleTableIndex getIndex() {
        return this.index;
    }

    @NotNull
    public String getName() {
        return this.tableColumn.getName();
    }

    @Property(id="name", viewable=true, order=1)
    @Nullable
    public OracleTableColumn getTableColumn() {
        return this.tableColumn;
    }

    @Property(viewable=false, order=2)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Property(viewable=true, order=3)
    public boolean isAscending() {
        return this.ascending;
    }

    @Property(viewable=true, order=4)
    public String getColumnExpression() {
        return this.columnExpression;
    }

    @Nullable
    public String getDescription() {
        return this.tableColumn.getDescription();
    }

    public OracleTableIndex getParentObject() {
        return this.index;
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return this.index.getDataSource();
    }
}

