/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class GenericTableColumnManager
extends SQLTableColumnManager<GenericTableColumn, GenericTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericTableColumn> getObjectsCache(GenericTableColumn object) {
        return ((GenericStructContainer)((GenericTableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((DBSObject)((GenericTableBase)object.getParentObject()));
    }

    protected GenericTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        GenericTableBase tableBase = (GenericTableBase)((Object)container);
        DBSDataType columnType = GenericTableColumnManager.findBestDataType((DBPDataSource)tableBase.getDataSource(), (String[])DBConstants.DEFAULT_DATATYPE_NAMES);
        int columnSize = columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0;
        GenericTableColumn column = ((GenericDataSource)tableBase.getDataSource()).getMetaModel().createTableColumnImpl(monitor, tableBase, this.getNewColumnName(monitor, context, (DBSEntity)tableBase), columnType == null ? "INTEGER" : columnType.getName(), columnType == null ? 4 : columnType.getTypeID(), columnType == null ? 4 : columnType.getTypeID(), -1, columnSize, columnSize, null, null, 10, false, null, null, false, false);
        column.setPersisted(false);
        return column;
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, GenericTableBase owner, DBECommandAbstract<GenericTableColumn> command, Map<String, Object> options) {
        String autoIncrementClause;
        StringBuilder decl = super.getNestedDeclaration(monitor, (DBSEntity)owner, command, options);
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        if (column.isAutoIncrement() && (autoIncrementClause = column.getDataSource().getMetaModel().getAutoIncrementClause(column)) != null && !autoIncrementClause.isEmpty()) {
            decl.append(" ").append(autoIncrementClause);
        }
        return decl;
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(GenericTableColumn column, Map<String, Object> options) {
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.DefaultModifier, this.NotNullModifier};
    }

    protected long getDDLFeatures(GenericTableColumn object) {
        long features = 0L;
        Object shortDrop = object.getDataSource().getContainer().getDriver().getDriverParameter("ddl-drop-column-short");
        if (shortDrop != null && CommonUtils.toBoolean((Object)shortDrop)) {
            features |= 1L;
        }
        return features;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        if (command.getProperty((Object)"description") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()))));
        }
    }
}

