/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.tools.maintenance.DB2BaseTableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.ui.UIUtils;

public class DB2RunstatsDialog
extends DB2BaseTableToolDialog {
    private Button dlgColsAllAndDistribution;
    private Button dlgColsAll;
    private Button dlgSample;
    private Spinner dlgSampleValue;
    private Button dlgIndexesDetailed;
    private Button dlgIndexesAll;

    public DB2RunstatsDialog(IWorkbenchPartSite partSite, Collection<DB2Table> selectedTables) {
        super(partSite, DB2Messages.dialog_table_tools_runstats_title, selectedTables);
    }

    protected void createControls(Composite parent) {
        Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)DB2Messages.dialog_table_tools_options, (int)1, (int)0, (int)0);
        optionsGroup.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)optionsGroup, 2);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        UIUtils.createLabel((Composite)composite, (String)DB2Messages.dialog_table_tools_runstats_cols_title).setLayoutData((Object)new GridData(2));
        Composite groupCols = new Composite(composite, 0);
        groupCols.setLayout((Layout)new RowLayout(512));
        this.dlgColsAllAndDistribution = new Button(groupCols, 16);
        this.dlgColsAllAndDistribution.setText(DB2Messages.dialog_table_tools_runstats_cols_all_and_distribution);
        this.dlgColsAllAndDistribution.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgColsAll = new Button(groupCols, 16);
        this.dlgColsAll.setText(DB2Messages.dialog_table_tools_runstats_cols_all);
        this.dlgColsAll.addSelectionListener(this.SQL_CHANGE_LISTENER);
        Button dlgColsNo = new Button(groupCols, 16);
        dlgColsNo.setText(DB2Messages.dialog_table_tools_runstats_cols_no);
        dlgColsNo.addSelectionListener(this.SQL_CHANGE_LISTENER);
        UIUtils.createLabel((Composite)composite, (String)DB2Messages.dialog_table_tools_runstats_indexes_title).setLayoutData((Object)new GridData(2));
        Composite groupIx = new Composite(composite, 0);
        groupIx.setLayout((Layout)new RowLayout(512));
        this.dlgIndexesDetailed = new Button(groupIx, 16);
        this.dlgIndexesDetailed.setText(DB2Messages.dialog_table_tools_runstats_indexes_detailed);
        this.dlgIndexesDetailed.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgIndexesAll = new Button(groupIx, 16);
        this.dlgIndexesAll.setText(DB2Messages.dialog_table_tools_runstats_indexes_all);
        this.dlgIndexesAll.addSelectionListener(this.SQL_CHANGE_LISTENER);
        Button dlgIndexesNo = new Button(groupIx, 16);
        dlgIndexesNo.setText(DB2Messages.dialog_table_tools_runstats_indexes_no);
        dlgIndexesNo.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgSample = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_runstats_stats_title, (boolean)false);
        this.dlgSample.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DB2RunstatsDialog.this.dlgSampleValue.setEnabled(DB2RunstatsDialog.this.dlgSample.getSelection());
                DB2RunstatsDialog.this.updateSQL();
            }
        });
        this.dlgSampleValue = new Spinner(composite, 2048);
        this.dlgSampleValue.setMinimum(0);
        this.dlgSampleValue.setMaximum(100);
        this.dlgSampleValue.setIncrement(1);
        Rectangle clientArea = this.getShell().getClientArea();
        this.dlgSampleValue.setLocation(clientArea.x, clientArea.y);
        this.dlgSampleValue.pack();
        this.dlgSampleValue.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgColsAllAndDistribution.setSelection(true);
        this.dlgIndexesDetailed.setSelection(true);
        this.dlgSampleValue.setSelection(0);
        this.dlgSampleValue.setEnabled(false);
        this.createObjectsSelector(parent);
    }

    protected void generateObjectCommand(List<String> lines, DB2Table db2Table) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CALL SYSPROC.ADMIN_CMD('");
        sb.append("RUNSTATS ON TABLE ").append(db2Table.getFullyQualifiedName(DBPEvaluationContext.DDL));
        if (this.dlgColsAllAndDistribution.getSelection()) {
            sb.append(" ON ALL COLUMNS WITH DISTRIBUTION ON ALL COLUMNS");
        }
        if (this.dlgColsAll.getSelection()) {
            sb.append(" ON ALL COLUMNS");
        }
        if (this.dlgIndexesDetailed.getSelection()) {
            sb.append(" AND SAMPLED DETAILED INDEXES ALL");
        }
        if (this.dlgIndexesAll.getSelection()) {
            sb.append(" AND INDEXES ALL");
        }
        if (this.dlgSample.getSelection()) {
            sb.append(" TABLESAMPLE SYSTEM(").append(this.dlgSampleValue.getSelection()).append(")");
        }
        sb.append("')");
        lines.add(sb.toString());
    }
}

