/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;

public class BaseBrowserView
extends ViewPart {
    private static final Log log = Log.getLog(BaseBrowserView.class);
    public static final String MEMENTO_URL = "url";
    private Browser browser;
    private String initialUrl = "about:blank";
    private Action backAction = new Action("Back", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_LEFT)){

        public void run() {
            BaseBrowserView.this.browser.back();
        }
    };
    private Action forwardAction = new Action("Forward", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_RIGHT)){

        public void run() {
            BaseBrowserView.this.browser.forward();
        }
    };
    private Action stopAction = new Action("Stop", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REJECT)){

        public void run() {
            BaseBrowserView.this.browser.stop();
        }
    };
    private Action refreshAction = new Action("Refresh", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH)){

        public void run() {
            BaseBrowserView.this.browser.refresh();
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String u;
        super.init(site);
        if (memento != null && (u = memento.getString(MEMENTO_URL)) != null) {
            this.initialUrl = u;
        }
    }

    public void saveState(IMemento memento) {
        memento.putString(MEMENTO_URL, this.browser.getUrl());
    }

    public void createPartControl(Composite parent) {
        this.browser = this.createBrowser(parent, this.getViewSite().getActionBars());
        this.browser.setUrl(this.initialUrl);
    }

    public void setFocus() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setFocus();
        }
    }

    private Browser createBrowser(Composite parent, IActionBars actionBars) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this.browser = new Browser(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.browser.setLayoutData((Object)data);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(actionBars){
            IProgressMonitor monitor;
            boolean working;
            int workedSoFar;
            {
                this.monitor = iActionBars.getStatusLineManager().getProgressMonitor();
                this.working = false;
            }

            public void changed(ProgressEvent event) {
                if (event.total == 0) {
                    return;
                }
                if (!this.working) {
                    if (event.current == event.total) {
                        return;
                    }
                    this.monitor.beginTask("", event.total);
                    this.workedSoFar = 0;
                    this.working = true;
                }
                this.monitor.worked(event.current - this.workedSoFar);
                this.workedSoFar = event.current;
            }

            public void completed(ProgressEvent event) {
                this.monitor.done();
                this.working = false;
            }
        });
        this.browser.addStatusTextListener(new StatusTextListener(actionBars){
            IStatusLineManager status;
            {
                this.status = iActionBars.getStatusLineManager();
            }

            public void changed(StatusTextEvent event) {
                this.status.setMessage(event.text);
            }
        });
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                BaseBrowserView.this.backAction.setEnabled(BaseBrowserView.this.browser.isBackEnabled());
                BaseBrowserView.this.forwardAction.setEnabled(BaseBrowserView.this.browser.isForwardEnabled());
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                BaseBrowserView.this.setPartName(event.title);
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                BaseBrowserView.this.close();
            }
        });
        actionBars.setGlobalActionHandler("back", (IAction)this.backAction);
        actionBars.setGlobalActionHandler("forward", (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler("stop", (IAction)this.stopAction);
        actionBars.setGlobalActionHandler("refresh", (IAction)this.refreshAction);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)this.backAction);
        toolBarManager.add((IAction)this.forwardAction);
        toolBarManager.add((IAction)this.stopAction);
        toolBarManager.add((IAction)this.refreshAction);
        this.backAction.setEnabled(false);
        this.forwardAction.setEnabled(false);
        return this.browser;
    }

    private void close() {
        IWorkbenchPage page = this.getSite().getPage();
        page.getWorkbenchWindow();
        page.hideView((IViewPart)this);
    }

    public Browser getBrowser() {
        return this.browser;
    }
}

