/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.jkiss.dbeaver.ext.erd.command.EntityAddCommand;
import org.jkiss.dbeaver.ext.erd.model.ERDContainer;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class QueryTableAddCommand
extends EntityAddCommand {
    private final VQBQueryInfo queryInfo = VQBUtils.getQueryInfo((EditPart)this.getDiagram());

    public QueryTableAddCommand(DiagramPart diagram, List<ERDEntity> entities, Point location) {
        super(diagram, entities, location);
    }

    protected void handleEntityChange(ERDEntity entity, boolean remove) {
        super.handleEntityChange(entity, remove);
        VQBUtils.handleEntityChange((ERDContainer)this.getDiagram().getDiagram(), this.queryInfo, entity, remove);
    }

    public void execute() {
        DBPDataSource dataSource = this.queryInfo.getQuery().getDataSource();
        if (dataSource != null) {
            for (ERDEntity entity : this.entities) {
                DBPDataSource eds = entity.getDataSource();
                if (eds == null && entity.getObject() != null) {
                    eds = ((DBSEntity)entity.getObject()).getDataSource();
                }
                if (eds == null || eds == dataSource) continue;
                DBWorkbench.getPlatformUI().showError("Wrong connection", "You can't add table from another database connection (" + ((DBSEntity)entity.getObject()).getDataSource().getName() + ").\n" + "Please use only tables from '" + dataSource.getName() + "'.");
                return;
            }
        }
        super.execute();
    }
}

