/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.commands.VQBDiagramCommand;
import com.dbeaver.ee.vqb.ui.model.ERDJoin;
import java.util.List;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.command.AssociationCreateCommand;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.utils.CommonUtils;

public class JoinCreateCommand
extends AssociationCreateCommand
implements VQBDiagramCommand {
    private static final Log log = Log.getLog(JoinCreateCommand.class);
    private final EntityDiagram entityDiagram;
    private final VQBQueryInfo queryInfo;

    public JoinCreateCommand(EntityDiagram entityDiagram, VQBQueryInfo queryInfo) {
        this.entityDiagram = entityDiagram;
        this.queryInfo = queryInfo;
    }

    protected ERDAssociation createAssociation(ERDElement sourceEntity, ERDElement targetEntity, boolean reflect) {
        if (sourceEntity instanceof ERDEntity && targetEntity instanceof ERDEntity) {
            ERDJoin erdJoin = new ERDJoin((ERDEntity)sourceEntity, (ERDEntity)targetEntity, reflect);
            if (this.getSourceAttribute() != null && this.getTargetAttribute() != null) {
                erdJoin.addCondition(this.getSourceAttribute(), this.getTargetAttribute());
            }
            return erdJoin;
        }
        return null;
    }

    public boolean canExecute() {
        if (this.getSourceAttribute() == null || this.getTargetAttribute() == null || CommonUtils.equalObjects((Object)this.getSourceAttribute(), (Object)this.getTargetAttribute())) {
            return false;
        }
        return this.getSourceEntity() instanceof ERDEntity && this.getTargetEntity() instanceof ERDEntity;
    }

    public void execute() {
        this.association = this.execute(false);
    }

    public void undo() {
        super.undo();
        this.execute(true);
        this.association = null;
    }

    private ERDJoin execute(boolean undo) {
        ERDJoin erdJoin = null;
        PlainSelect plainSelect = this.queryInfo.getPlainSelect();
        if (plainSelect != null) {
            if (!undo) {
                Join join = VQBUtils.findEntityJoin(this.entityDiagram, plainSelect, (ERDEntity)this.sourceEntity, (ERDEntity)this.targetEntity);
                if (join != null) {
                    join.setInner(true);
                    erdJoin = VQBUtils.findERDJoin(this.entityDiagram, join);
                    if (erdJoin != null) {
                        erdJoin.addCondition(this.getSourceAttribute(), this.getTargetAttribute());
                        erdJoin.updateStatementJoin(join);
                    } else {
                        erdJoin = new ERDJoin((ERDEntity)this.sourceEntity, (ERDEntity)this.targetEntity, true);
                        erdJoin.setUserData(join);
                        erdJoin.addCondition(this.getSourceAttribute(), this.getTargetAttribute());
                        erdJoin.updateStatementJoin(join);
                    }
                } else {
                    erdJoin = new ERDJoin((ERDEntity)this.sourceEntity, (ERDEntity)this.targetEntity, true);
                    erdJoin.addCondition(this.getSourceAttribute(), this.getTargetAttribute());
                    join = erdJoin.createStatementJoin();
                    VQBUtils.getQueryJoins(plainSelect).add(join);
                }
            } else {
                erdJoin = (ERDJoin)this.association;
                Join join = (Join)erdJoin.getUserData();
                List joins = plainSelect.getJoins();
                if (joins != null) {
                    joins.remove(join);
                }
            }
        }
        return erdJoin;
    }
}

