/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.features;

import com.dbeaver.model.sql.plan.emf.SQLPlan;
import com.dbeaver.model.sql.plan.emf.SQLPlanNode;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import com.dbeaver.ui.editors.sql.plan.diagram.util.PlanDiagramUtil;
import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class PlansCollapseDummyFeature
extends AbstractCustomFeature {
    private boolean isCollapsed = false;

    public PlansCollapseDummyFeature(IFeatureProvider fp, boolean collapsed) {
        super(fp);
        this.isCollapsed = collapsed;
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public boolean canExecute(ICustomContext context) {
        PlanNodeRenderInfo renderInfo = PlanDiagramUtil.getRenderInfo(context);
        if (renderInfo == null) {
            return false;
        }
        return renderInfo.getNode().getChildNodes().size() > 0;
    }

    public String getName() {
        return this.isCollapsed ? "Expand" : "Collapse";
    }

    public String getDescription() {
        return this.isCollapsed ? "Expand child nodes" : "Collapse child nodes";
    }

    public String getImageId() {
        return this.isCollapsed ? "org.eclipse.graphiti.edit.expand" : "org.eclipse.graphiti.edit.collapse";
    }

    public boolean isAvailable(IContext context) {
        return this.canExecute(context);
    }

    public void expandNode(SQLPlanNode node, PlanNodeRenderInfo renderInfo) {
        List subtree = SQLPlan.subTree((SQLPlanNode)node);
        for (SQLPlanNode p : subtree) {
            if (p.getCollapsedBy() != node) continue;
            ContainerShape shape = (ContainerShape)p.getContainer();
            shape.setActive(true);
            for (Anchor anchors : shape.getAnchors()) {
                for (Connection c : anchors.getIncomingConnections()) {
                    c.setActive(true);
                    c.setVisible(true);
                }
            }
            shape.setVisible(true);
            p.setCollapsedBy(null);
        }
        node.setCollapsedBy(null);
        renderInfo.change();
        this.updatePictogramElement((PictogramElement)node.getContainer());
    }

    public void collapseNode(SQLPlanNode node, PlanNodeRenderInfo renderInfo) {
        List subtree = SQLPlan.subTree((SQLPlanNode)node);
        for (SQLPlanNode p : subtree) {
            if (p.isCollapsedBy()) continue;
            ContainerShape shape = (ContainerShape)p.getContainer();
            shape.setActive(false);
            for (Anchor anchors : shape.getAnchors()) {
                for (Connection c : anchors.getIncomingConnections()) {
                    c.setActive(false);
                    c.setVisible(false);
                }
            }
            shape.setVisible(false);
            p.setCollapsedBy(node);
        }
        node.setCollapsedBy(node);
        renderInfo.change();
        this.updatePictogramElement((PictogramElement)node.getContainer());
    }

    public void execute(ICustomContext context) {
        PlanNodeRenderInfo renderInfo = PlanDiagramUtil.getRenderInfo(context);
        if (renderInfo == null) {
            return;
        }
        SQLPlanNode node = renderInfo.getNode();
        if (node.isCollapsedBy() || node.getCollapsedBy() == node) {
            this.expandNode(node, renderInfo);
            this.isCollapsed = false;
        } else {
            this.collapseNode(node, renderInfo);
            this.isCollapsed = true;
        }
    }
}

