/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.validate;

import com.dbeaver.lm.internal.core.LMMessages;
import com.dbeaver.lm.validate.LicenseCheckResult;
import com.dbeaver.lm.validate.PublicServiceClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseStatus;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMSubscription;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.CommonUtils;

public class LMPublicAPI {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.dbeaver.lm.core";
    private static final Log log = Log.getLog(LMPublicAPI.class);
    private static final int LICENSE_CHECK_TIMEOUT = 4000;

    public static IStatus generateTrialLicense(IProgressMonitor monitor, LMLicenseManager licenseManager, String clientId, LMProduct product, String email, String firstName, String lastName, String company) {
        return LMPublicAPI.generateLicense(monitor, licenseManager, clientId, product, email, firstName, lastName, company);
    }

    public static LicenseCheckResult checkLicenseStatus(IProgressMonitor monitor, String clientId, LMLicenseManager licenseManager, LMLicense license, LMProduct product) {
        monitor.beginTask("Check license status", 3);
        try {
            LMLicenseStatus licenseStatus;
            BufferedReader br;
            PublicServiceClient client = new PublicServiceClient(clientId, 4000, 4000);
            try {
                monitor.subTask("Validate license " + license.getLicenseId());
                String licenseStatusText = client.checkLicenseStatus(license, product);
                if (CommonUtils.isEmpty((String)licenseStatusText)) {
                    LicenseCheckResult licenseCheckResult = new LicenseCheckResult(Status.OK_STATUS, LMLicenseStatus.VALID);
                    return licenseCheckResult;
                }
                br = new BufferedReader(new StringReader(licenseStatusText));
            }
            catch (Exception e) {
                LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)"Error checking license status", (Throwable)e), LMLicenseStatus.VALID);
                return licenseCheckResult;
            }
            String licenseStatusString = br.readLine();
            monitor.worked(1);
            int divPos = licenseStatusString.indexOf(58);
            if (divPos == -1) {
                LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)("Bad check status: " + licenseStatusString)), LMLicenseStatus.INVALID);
                return licenseCheckResult;
            }
            String statusCode = licenseStatusString.substring(0, divPos).trim();
            String statusMessage = licenseStatusString.substring(divPos + 1).trim();
            try {
                licenseStatus = LMLicenseStatus.valueOf((String)statusCode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)("Bad license status: [" + statusCode + "]"));
                licenseStatus = LMLicenseStatus.VALID;
            }
            LicenseCheckResult checkResult = new LicenseCheckResult(GeneralUtils.makeInfoStatus((String)statusMessage), licenseStatus);
            if (license.isSubscription()) {
                try {
                    byte[] subEncrypted = LMUtils.readEncryptedString((Reader)br);
                    LMSubscription subscription = licenseManager.readSubscriptionFromData(product, subEncrypted);
                    checkResult.setSubscription(subscription);
                }
                catch (IOException e) {
                    log.debug((Object)"Error reading subscription info", (Throwable)e);
                }
            }
            LicenseCheckResult licenseCheckResult = checkResult;
            return licenseCheckResult;
        }
        finally {
            monitor.done();
        }
    }

    private static IStatus generateLicense(IProgressMonitor monitor, LMLicenseManager licenseManager, String clientId, LMProduct product, String email, String firstName, String lastName, String company) {
        monitor.beginTask("Generate trial license", 3);
        try {
            String licenseEncoded;
            PublicServiceClient client = new PublicServiceClient(clientId);
            try {
                monitor.subTask("Check license server");
                log.debug((Object)"Ping license server");
                String pingResult = client.ping();
                log.debug((Object)("Ping result: " + pingResult));
                monitor.worked(1);
            }
            catch (Exception e) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Can't contact license service at dbeaver.com", (Throwable)e);
                monitor.done();
                return iStatus;
            }
            try {
                monitor.subTask("Generate license");
                log.debug((Object)"Request trial license");
                licenseEncoded = client.generateTrialLicense(product, email, firstName, lastName, company);
                monitor.worked(1);
            }
            catch (Exception e) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)NLS.bind((String)LMMessages.api_error_status_cant_generate_trial_license, (Object)":\n", (Object)e.getMessage()));
                monitor.done();
                return iStatus;
            }
            try {
                monitor.subTask("Import license");
                byte[] licenseData = LMUtils.readEncryptedString((Reader)new StringReader(licenseEncoded));
                licenseManager.importLicense(product, licenseData, true);
                monitor.worked(1);
            }
            catch (Throwable e) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Trial license corrupted or doesn't match the product", (Throwable)e);
                monitor.done();
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

