/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.dbeaver.ee.scmp.model.CMPOptions;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class SchemaMappingDialog
extends BaseDialog {
    private final CMPOptions options;

    public SchemaMappingDialog(Shell shell, CMPOptions options) {
        super(shell, "Schema mapping", null);
        this.options = options;
        this.options.refreshSchemaMappings(false);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Table containerTable = new Table(composite, 67584);
        containerTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 300;
        gd.minimumHeight = 60;
        containerTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)containerTable, (int)16384, (String)"Source");
        UIUtils.createTableColumn((Table)containerTable, (int)131072, (String)"Target");
        for (DBSObjectContainer container : this.options.getSourceContainers()) {
            TableItem item = new TableItem(containerTable, 0);
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI));
            DBSObjectContainer targetContainer = this.options.getTargetContainer(container);
            item.setText(1, targetContainer == null ? "N/A" : DBUtils.getObjectFullName((DBPNamedObject)targetContainer, (DBPEvaluationContext)DBPEvaluationContext.UI));
            item.setData((Object)container);
        }
        UIUtils.executeOnResize((Control)containerTable, () -> UIUtils.packColumns((Table)containerTable, (boolean)true));
        new CustomTableEditor(containerTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                if (index != 1) {
                    return null;
                }
                CCombo editor = new CCombo((Composite)table, 2060);
                List targetContainers = SchemaMappingDialog.this.options.getTargetContainers();
                for (DBSObjectContainer container : targetContainers) {
                    editor.add(DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI));
                }
                DBSObjectContainer curValue = SchemaMappingDialog.this.options.getTargetContainer((DBSObjectContainer)item.getData());
                if (curValue != null) {
                    editor.select(targetContainers.indexOf(curValue));
                }
                return editor;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                int newIndex = ((CCombo)control).getSelectionIndex();
                if (newIndex < 0) {
                    SchemaMappingDialog.this.options.mapContainers((DBSObjectContainer)item.getData(), null);
                    item.setText(1, "N/A");
                } else {
                    List targetContainers = SchemaMappingDialog.this.options.getTargetContainers();
                    DBSObjectContainer newValue = (DBSObjectContainer)targetContainers.get(newIndex);
                    SchemaMappingDialog.this.options.mapContainers((DBSObjectContainer)item.getData(), newValue);
                    item.setText(1, DBUtils.getObjectFullName((DBPNamedObject)newValue, (DBPEvaluationContext)DBPEvaluationContext.UI));
                }
            }
        };
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

