/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.win;

import au.com.bytecode.opencsv.CSVReader;
import com.dbeaver.ee.sched.system.BaseSystemScheduler;
import com.dbeaver.ee.sched.system.win.WinTaskScheduleInfo;
import com.sun.jna.platform.win32.COM.COMLateBindingObject;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.Variant;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WinSystemScheduler
extends BaseSystemScheduler {
    private static final Log log = Log.getLog(WinSystemScheduler.class);
    public static final String DEFAULT_TASK_PREFIX = "DBeaver\\";
    public static final String SEARCH_TASK_PREFIX = "\\DBeaver\\";
    private static final boolean USE_JAVA_FORMAT = false;
    private Map<String, WinTaskScheduleInfo> detailsMap = new LinkedHashMap<String, WinTaskScheduleInfo>();

    @NotNull
    public String getSchedulerName() {
        return "Local Windows Task Scheduler";
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() {
        return new ArrayList<DBTTaskScheduleInfo>(this.detailsMap.values());
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        return this.detailsMap.get(task.getName());
    }

    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) throws DBException {
        String csv = this.executeSchTasks("/Query", "/XML", "/TN", this.makeTaskName(task));
        try {
            Document taskInfoDoc = XMLUtils.parseDocument((Reader)new StringReader(csv));
            return this.parseWTSConfiguration(task, taskInfoDoc);
        }
        catch (XMLException e) {
            throw new DBException("Error parsing task info XML", (Throwable)e);
        }
    }

    private DBTTaskScheduleConfiguration parseWTSConfiguration(DBTTask task, Document document) {
        DBTTaskScheduleConfiguration cfg;
        block74: {
            Element domNode;
            Element sbmNode;
            block79: {
                Element calTriggerNode;
                block77: {
                    block76: {
                        Element triggersNode;
                        block75: {
                            String interval;
                            Element timeTriggerNode;
                            cfg = new DBTTaskScheduleConfiguration();
                            cfg.frequency = DBTTaskScheduleConfiguration.Frequency.MINUTELY;
                            triggersNode = XMLUtils.getChildElement((Element)document.getDocumentElement(), (String)"Triggers");
                            Element element = timeTriggerNode = triggersNode == null ? null : XMLUtils.getChildElement((Element)triggersNode, (String)"TimeTrigger");
                            if (timeTriggerNode == null) break block75;
                            this.parseStartBoundary(cfg, timeTriggerNode);
                            Element repetitionNode = XMLUtils.getChildElement((Element)timeTriggerNode, (String)"Repetition");
                            String string = interval = repetitionNode == null ? null : XMLUtils.getChildElementBody((Element)repetitionNode, (String)"Interval");
                            if (CommonUtils.isEmpty((String)interval)) break block74;
                            try {
                                Duration duration = Duration.parse(interval);
                                if (duration.toHours() > 0L) {
                                    cfg.frequency = DBTTaskScheduleConfiguration.Frequency.HOURLY;
                                    cfg.recurrence = (int)duration.toHours();
                                } else if (duration.toMinutes() > 0L) {
                                    cfg.frequency = DBTTaskScheduleConfiguration.Frequency.MINUTELY;
                                    cfg.recurrence = (int)duration.toMinutes();
                                }
                                break block74;
                            }
                            catch (Exception e) {
                                log.error((Object)("Error parsing interval (" + interval + ")"), (Throwable)e);
                            }
                            break block74;
                        }
                        Element element = calTriggerNode = triggersNode == null ? null : XMLUtils.getChildElement((Element)triggersNode, (String)"CalendarTrigger");
                        if (calTriggerNode == null) break block74;
                        this.parseStartBoundary(cfg, calTriggerNode);
                        Element sbdNode = XMLUtils.getChildElement((Element)calTriggerNode, (String)"ScheduleByDay");
                        if (sbdNode == null) break block76;
                        cfg.frequency = DBTTaskScheduleConfiguration.Frequency.DAILY;
                        cfg.recurrence = CommonUtils.toInt((Object)XMLUtils.getChildElementBody((Element)sbdNode, (String)"DaysInterval"));
                        break block74;
                    }
                    Element sbwNode = XMLUtils.getChildElement((Element)calTriggerNode, (String)"ScheduleByWeek");
                    if (sbwNode == null) break block77;
                    cfg.frequency = DBTTaskScheduleConfiguration.Frequency.WEEKLY;
                    cfg.recurrence = CommonUtils.toInt((Object)XMLUtils.getChildElementBody((Element)sbwNode, (String)"WeeksInterval"));
                    Element dowNode = XMLUtils.getChildElement((Element)sbwNode, (String)"DaysOfWeek");
                    if (dowNode == null) break block74;
                    cfg.days = new ArrayList();
                    for (Element dNode : XMLUtils.getChildElementList((Element)dowNode)) {
                        int dayNum;
                        String dayName = dNode.getTagName();
                        if (dayName == null) continue;
                        switch (dayName = dayName.toLowerCase(Locale.ENGLISH)) {
                            case "monday": {
                                dayNum = 2;
                                break;
                            }
                            case "tuesday": {
                                dayNum = 3;
                                break;
                            }
                            case "wednesday": {
                                dayNum = 4;
                                break;
                            }
                            case "thursday": {
                                dayNum = 5;
                                break;
                            }
                            case "friday": {
                                dayNum = 6;
                                break;
                            }
                            case "saturday": {
                                dayNum = 7;
                                break;
                            }
                            case "sunday": {
                                dayNum = 1;
                                break;
                            }
                            default: {
                                dayNum = -1;
                            }
                        }
                        if (dayNum < 0) continue;
                        cfg.days.add((short)dayNum);
                    }
                    break block74;
                }
                sbmNode = XMLUtils.getChildElement((Element)calTriggerNode, (String)"ScheduleByMonth");
                if (sbmNode == null) break block74;
                cfg.frequency = DBTTaskScheduleConfiguration.Frequency.MONTHLY;
                Element monNode = XMLUtils.getChildElement((Element)sbmNode, (String)"Months");
                if (monNode == null) break block79;
                cfg.months = new ArrayList();
                for (Element mNode : XMLUtils.getChildElementList((Element)monNode)) {
                    int monthNum;
                    String monthName = mNode.getTagName();
                    if (monthName == null) continue;
                    switch (monthName = monthName.toLowerCase(Locale.ENGLISH)) {
                        case "january": {
                            monthNum = 0;
                            break;
                        }
                        case "february": {
                            monthNum = 1;
                            break;
                        }
                        case "march": {
                            monthNum = 2;
                            break;
                        }
                        case "april": {
                            monthNum = 3;
                            break;
                        }
                        case "may": {
                            monthNum = 4;
                            break;
                        }
                        case "june": {
                            monthNum = 5;
                            break;
                        }
                        case "july": {
                            monthNum = 6;
                            break;
                        }
                        case "august": {
                            monthNum = 7;
                            break;
                        }
                        case "september": {
                            monthNum = 8;
                            break;
                        }
                        case "october": {
                            monthNum = 9;
                            break;
                        }
                        case "november": {
                            monthNum = 10;
                            break;
                        }
                        case "december": {
                            monthNum = 11;
                            break;
                        }
                        default: {
                            monthNum = -1;
                        }
                    }
                    if (monthNum < 0) continue;
                    cfg.months.add((short)monthNum);
                }
            }
            if ((domNode = XMLUtils.getChildElement((Element)sbmNode, (String)"DaysOfMonth")) != null) {
                cfg.days = new ArrayList();
                for (Element dNode : XMLUtils.getChildElementList((Element)domNode)) {
                    String dayNum = XMLUtils.getElementBody((Element)dNode);
                    if (dayNum == null) continue;
                    cfg.days.add((short)CommonUtils.toInt((Object)dayNum));
                }
            }
        }
        return cfg;
    }

    private void parseStartBoundary(DBTTaskScheduleConfiguration cfg, Element timeTriggerNode) {
        String startBoundary = XMLUtils.getChildElementBody((Element)timeTriggerNode, (String)"StartBoundary");
        if (!CommonUtils.isEmpty((String)startBoundary)) {
            try {
                cfg.startTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(startBoundary);
            }
            catch (ParseException e) {
                log.error((Object)("Error parsing StartBoundary (" + startBoundary + ")"), (Throwable)e);
            }
        }
    }

    public void setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration configuration) throws DBException {
        String resultStr;
        DBTTaskScheduleInfo taskInfo;
        ArrayList<String> mdList;
        if (!DBWorkbench.getPlatform().getApplication().isStandalone()) {
            throw new DBException("Cannot schedule tasks in Windows scheduler in plugin mode. Use standalone application.");
        }
        boolean isUpdate = this.getScheduledTaskInfo(task) != null;
        ArrayList<Short> days = null;
        boolean isLastDay = false;
        if (!CommonUtils.isEmpty((Collection)configuration.days)) {
            days = new ArrayList<Short>();
            for (Short dayNum : configuration.days) {
                if (dayNum == 32) {
                    isLastDay = true;
                    continue;
                }
                if (dayNum == 33) continue;
                days.add(dayNum);
            }
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("/Create");
        params.add("/SC");
        params.add(WinSystemScheduler.getWTSScheduleFrequency(configuration.frequency));
        if (configuration.recurrence > 0) {
            params.add("/MO");
            params.add(String.valueOf(configuration.recurrence));
        }
        if (isLastDay) {
            params.add("/MO");
            params.add("LASTDAY");
        } else if (!CommonUtils.isEmpty(days)) {
            params.add("/D");
            if (configuration.frequency == DBTTaskScheduleConfiguration.Frequency.WEEKLY) {
                ArrayList<String> wdList = new ArrayList<String>();
                for (Short dayNum : days) {
                    wdList.add(this.getWTSWeekDay(dayNum));
                }
                params.add(String.join((CharSequence)",", wdList));
            } else {
                mdList = new ArrayList<String>();
                Iterator iterator = days.iterator();
                if (iterator.hasNext()) {
                    Short dayNum;
                    dayNum = (Short)iterator.next();
                    mdList.add(String.valueOf(dayNum));
                }
                params.add(String.join((CharSequence)",", mdList));
            }
        }
        if (!CommonUtils.isEmpty((Collection)configuration.months)) {
            params.add("/M");
            mdList = new ArrayList();
            for (Short monthNum : configuration.months) {
                mdList.add(this.getWTSScheduleMonth(monthNum.shortValue()));
            }
            params.add(String.join((CharSequence)",", mdList));
        }
        if (configuration.repetitionInterval > 0) {
            params.add("/RI");
            params.add(String.valueOf(configuration.repetitionInterval));
        }
        if (!(configuration.startTime == null || configuration.frequency == DBTTaskScheduleConfiguration.Frequency.ONE_TIME && configuration.startTime.before(new Date()))) {
            String startDate = new SimpleDateFormat(this.getDatePattern()).format(configuration.startTime);
            params.add("/SD");
            params.add(startDate);
            String startTime = new SimpleDateFormat("HH:mm").format(configuration.startTime);
            params.add("/ST");
            params.add(startTime);
        }
        String taskName = this.makeTaskName(task);
        params.add("/TN");
        params.add(taskName);
        params.add("/TR");
        String appLauncherFullPath = System.getProperty("eclipse.launcher");
        params.add("\\\"" + appLauncherFullPath + "\\\" -runTask \\\"@" + task.getProject().getName() + ":" + task.getName() + "\\\" -nosplash");
        if (isUpdate && (taskInfo = this.getScheduledTaskInfo(task)) != null) {
            try {
                this.removeTaskSchedule(task, taskInfo);
            }
            catch (DBException e) {
                log.debug((Object)"Error deleting previous task", (Throwable)e);
            }
        }
        if ((resultStr = this.executeSchTasks(params.toArray(new String[0]))).startsWith("ERROR")) {
            throw new DBException("Error scheduling task: " + resultStr);
        }
        log.debug((Object)("schtasks.exe: " + resultStr));
    }

    @NotNull
    private String getDatePattern() {
        try {
            String curDate = RuntimeUtils.executeProcess((String)"cmd.exe", (String[])new String[]{"/C", "echo %DATE%"});
            if (curDate != null) {
                int divPos = (curDate = curDate.trim()).indexOf(32);
                if (divPos != -1) {
                    curDate = curDate.substring(divPos + 1).trim();
                }
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                cal.get(1);
                cal.get(2);
                int datOfMonth = cal.get(5);
                String[] dateParts = curDate.split("/");
                if (dateParts.length == 3) {
                    if (String.valueOf(datOfMonth).equals(dateParts[0])) {
                        return "dd/MM/yyyy";
                    }
                    return "MM/dd/yyyy";
                }
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
        return "dd/MM/yyyy";
    }

    private String makeTaskName(DBTTask task) {
        return DEFAULT_TASK_PREFIX + task.getName();
    }

    private String getWTSWeekDay(Short dayNum) {
        switch (dayNum) {
            case 2: {
                return "MON";
            }
            case 3: {
                return "TUE";
            }
            case 4: {
                return "WED";
            }
            case 5: {
                return "THU";
            }
            case 6: {
                return "FRI";
            }
            case 7: {
                return "SAT";
            }
            case 1: {
                return "SUN";
            }
        }
        return "*";
    }

    private String getWTSScheduleMonth(int monthNum) {
        switch (monthNum) {
            case 0: {
                return "JAN";
            }
            case 1: {
                return "FEB";
            }
            case 2: {
                return "MAR";
            }
            case 3: {
                return "APR";
            }
            case 4: {
                return "MAY";
            }
            case 5: {
                return "JUN";
            }
            case 6: {
                return "JUL";
            }
            case 7: {
                return "AUG";
            }
            case 8: {
                return "SEP";
            }
            case 9: {
                return "OCT";
            }
            case 10: {
                return "NOV";
            }
            case 11: {
                return "DEC";
            }
        }
        return null;
    }

    private static String getWTSScheduleFrequency(DBTTaskScheduleConfiguration.Frequency frequency) {
        switch (frequency) {
            case MINUTELY: {
                return "MINUTE";
            }
            case HOURLY: {
                return "HOURLY";
            }
            case DAILY: {
                return "DAILY";
            }
            case WEEKLY: {
                return "WEEKLY";
            }
            case MONTHLY: {
                return "MONTHLY";
            }
        }
        return "ONCE";
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) throws DBException {
        ArrayList<String> params = new ArrayList<String>();
        params.add("/Delete");
        String taskName = this.makeTaskName(task);
        params.add("/TN");
        params.add(taskName);
        params.add("/F");
        String resultStr = this.executeSchTasks(params.toArray(new String[0]));
        if (resultStr.startsWith("ERROR")) {
            throw new DBException("Error removing scheduled task: " + resultStr);
        }
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) throws DBException {
        String csv = this.executeSchTasks("/Query", "/FO", "CSV");
        ArrayList<WinTaskScheduleInfo> details = new ArrayList<WinTaskScheduleInfo>();
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (CSVReader csvReader = new CSVReader((Reader)new StringReader(csv), ',', '\"', '|');){
                List strings = csvReader.readAll();
                int i = 1;
                while (i < strings.size()) {
                    String[] line = (String[])strings.get(i);
                    if (line.length == 3) {
                        String taskId = line[0];
                        String nextRunTime = line[1];
                        String status = line[2];
                        if (!CommonUtils.isEmpty((String)taskId) && taskId.startsWith(SEARCH_TASK_PREFIX)) {
                            taskId = taskId.substring(SEARCH_TASK_PREFIX.length());
                            details.add(new WinTaskScheduleInfo(taskId, nextRunTime, status));
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("IO error", (Throwable)e);
        }
        this.detailsMap.clear();
        for (WinTaskScheduleInfo info : details) {
            this.detailsMap.put(info.getTaskId(), info);
        }
    }

    public void openSchedulerSettings() throws DBException {
        RuntimeUtils.executeProcess((String)"cmd.exe", (String[])new String[]{"/C", "start", "taskschd.msc"});
    }

    private String executeSchTasks(String ... parameters) throws DBException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("/C");
        args.add("schtasks.exe");
        Collections.addAll(args, parameters);
        log.debug((Object)("Run Windows scheduler with parameters [" + String.join((CharSequence)" ", parameters) + "]"));
        return RuntimeUtils.executeProcess((String)"cmd.exe", (String[])args.toArray(new String[0]));
    }

    private static class COMTask
    extends COMLateBindingObject {
        public COMTask(IDispatch dispatch) {
            super(dispatch);
        }

        void editWorkItem() {
            this.invoke("EditWorkItem", new Variant.VARIANT(0));
        }
    }
}

