/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system;

import com.dbeaver.ee.sched.system.BaseSystemScheduler;
import com.dbeaver.ee.sched.system.cron.CronSystemScheduler;
import com.dbeaver.ee.sched.system.win.WinSystemScheduler;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SystemScheduler
implements DBTScheduler {
    private final BaseSystemScheduler impl = GeneralUtils.isWindows() ? new WinSystemScheduler() : new CronSystemScheduler();

    @NotNull
    public String getSchedulerName() {
        return this.impl.getSchedulerName();
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() {
        return this.impl.getAllScheduledTasks();
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        return this.impl.getScheduledTaskInfo(task);
    }

    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) throws DBException {
        return this.impl.getScheduledTaskConfiguration(task);
    }

    public void setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        this.impl.setTaskSchedule(task, scheduleConfiguration);
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) throws DBException {
        this.impl.removeTaskSchedule(task, scheduleInfo);
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.impl.refreshScheduledTasks(monitor);
    }

    public void openSchedulerSettings() throws DBException {
        this.impl.openSchedulerSettings();
    }
}

