/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.security;

import com.dbeaver.ee.runtime.core.EnterpriseProjectSecureStorage;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.crypto.SecretKey;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.utils.CommonUtils;

public class ConsoleServiceSecurityImpl
implements UIServiceSecurity {
    private static final Log log = Log.getLog(ConsoleServiceSecurityImpl.class);

    public String askForPassword(@NotNull String title, String message, @Nullable String defPassword, boolean emptyPasswordAllowed) {
        String password;
        block6: {
            if (DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
                log.error((Object)(String.valueOf(title) + "\nWARNING: User password requested in headless mode. Passing null value."));
                return null;
            }
            Console console = System.console();
            if (console != null) {
                console.printf(String.valueOf(title) + "\n", new Object[0]);
                char[] passwordArray = console.readPassword(String.valueOf(message) + ": ", new Object[0]);
                if (passwordArray == null || passwordArray.length == 0) {
                    return null;
                }
                return new String(passwordArray);
            }
            System.out.println(title);
            System.out.print(String.valueOf(message) + ": ");
            try {
                password = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (!CommonUtils.isEmpty((String)password)) break block6;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return password;
    }

    public String askForNewPassword(@NotNull String title, @Nullable String defPassword) {
        return this.askForPassword(title, "Enter new password", defPassword, false);
    }

    public String askForPasswordChange(@NotNull String title, @NotNull String currentPassword) {
        return null;
    }

    public boolean validatePassword(DBASecureStorage secureStorage, String title, String message) {
        if (secureStorage instanceof EnterpriseProjectSecureStorage) {
            return this.validateProjectPassword((EnterpriseProjectSecureStorage)secureStorage, title, message);
        }
        return false;
    }

    private boolean validateProjectPassword(EnterpriseProjectSecureStorage storage, String title, String message) {
        DBPProject project = storage.getProject();
        boolean isSecured = CommonUtils.toBoolean((Object)project.getProjectProperty("useProjectPassword"));
        if (!isSecured) {
            return true;
        }
        String password = this.askForPassword(title, message, null, false);
        if (password == null) {
            return false;
        }
        SecretKey key = storage.makeSecretKeyFromPassword(password);
        if (!storage.isValidSecretKey(key)) {
            System.out.println(String.valueOf(title) + "\nIncorrect password");
            return false;
        }
        return true;
    }
}

