/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.core;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.registry.ProjectSecureStorage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.ContentEncrypter;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class EnterpriseProjectSecureStorage
extends ProjectSecureStorage {
    private static final Log log = Log.getLog(EnterpriseProjectSecureStorage.class);
    private SecretKey projectPassword;

    public EnterpriseProjectSecureStorage(DBPProject project) {
        super(project);
    }

    private boolean isProjectPasswordUsed() {
        return CommonUtils.getBoolean((Object)this.project.getProjectProperty("useProjectPassword"), (boolean)false);
    }

    public boolean useSecurePreferences() {
        return !this.isProjectPasswordUsed() && super.useSecurePreferences();
    }

    public SecretKey getLocalSecretKey() {
        if (this.isProjectPasswordUsed()) {
            UIServiceSecurity serviceSecurity;
            if (this.projectPassword == null && (serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class)) != null) {
                this.projectPassword = this.acquireSecretKey(serviceSecurity);
            }
            if (this.projectPassword != null) {
                return this.projectPassword;
            }
        }
        return super.getLocalSecretKey();
    }

    private SecretKey acquireSecretKey(UIServiceSecurity serviceSecurity) {
        String password;
        String message = "Enter project master password";
        while ((password = serviceSecurity.askForPassword("Project '" + this.project.getName() + "' master password", message, null, false)) != null) {
            SecretKey key = this.makeSecretKeyFromPassword(password);
            if (this.isValidSecretKey(key)) {
                return key;
            }
            message = "Incorrect password. Try again";
        }
        return null;
    }

    public boolean isValidSecretKey(SecretKey key) {
        IFile credFile;
        IFolder mdFolder = this.project.getMetadataFolder(false);
        if (mdFolder.exists() && (credFile = mdFolder.getFile("credentials-config.json")).exists()) {
            byte[] bytes;
            try {
                bytes = IOUtils.readFileToBuffer((File)credFile.getLocation().toFile());
            }
            catch (IOException iOException) {
                log.error((Object)"Error reading credentials file");
                return true;
            }
            ContentEncrypter encrypter = new ContentEncrypter(key);
            try {
                encrypter.decrypt(bytes);
                return true;
            }
            catch (Exception e) {
                log.debug((Object)"Error decrypting secure credentials", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void setProjectPassword(String password) {
        this.projectPassword = CommonUtils.isEmpty((String)password) ? null : this.makeSecretKeyFromPassword(password);
    }

    public SecretKey makeSecretKeyFromPassword(String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] passBytes = Arrays.copyOf(bytes, 16);
        return new SecretKeySpec(passBytes, "AES");
    }
}

