/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.xml;

import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.TextRenderer;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLRenderer
extends TextRenderer {
    private static final Log log = Log.getLog(XMLRenderer.class);
    private Color colorDefault;
    private Color colorTag;
    private Color colorAttributeName;
    private Color colorAttributeValue;
    private int x;
    private int y;

    public XMLRenderer(IDocumentFrame documentFrame) {
        super(documentFrame);
    }

    @Override
    public void paintDocument(@NotNull GC gc, @NotNull Canvas canvas, @NotNull Rectangle bounds) {
        ColorRegistry colorRegistry = this.documentFrame.getController().getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorTag = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
        this.colorAttributeName = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.datatype.foreground");
        this.colorAttributeValue = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.string.foreground");
        this.colorDefault = canvas.getForeground();
        super.paintDocument(gc, canvas, bounds);
    }

    @Override
    protected void renderNode(TextRenderer.TextProcessor textProcessor, Object node, int x, int y) {
        this.x = x;
        this.y = y;
        this.renderTag(textProcessor, (Element)node, 1);
    }

    private void renderTag(TextRenderer.TextProcessor painter, Element node, int nodeLevel) {
        if (painter.isOutOfRange(this.y)) {
            return;
        }
        String name = node.getTagName();
        painter.drawText("<" + name, this.x, this.y, this.colorTag);
        boolean hasChildren = false;
        this.x += name.length() + 1;
        NamedNodeMap attrs = node.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            String value = attr.getValue();
            String key = attr.getName();
            painter.drawText(" " + key + "=", this.x, this.y, this.colorAttributeName);
            this.x += key.length() + 2;
            String strValue = XMLUtils.escapeXml((CharSequence)CommonUtils.toString((Object)value));
            painter.drawText("\"" + strValue + "\"", this.x, this.y, this.colorAttributeValue);
            this.x += strValue.length() + 2;
            ++i;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (!hasChildren) {
                painter.drawText(">", this.x, this.y, this.colorTag);
                ++this.x;
            }
            hasChildren = true;
            if (child instanceof Element) {
                this.renderTag(painter, (Element)child, nodeLevel + 1);
            } else if (child instanceof Text) {
                String text = ((Text)child).getWholeText();
                this.renderText(painter, text, this.colorDefault);
            }
            child = child.getNextSibling();
        }
        if (!hasChildren) {
            painter.drawText("/>", this.x, this.y, this.colorTag);
        } else {
            painter.drawText("</" + name + ">", this.x, this.y, this.colorTag);
        }
    }

    private void renderText(TextRenderer.TextProcessor painter, String text, Color color) {
        int divPos = text.indexOf(10);
        if (divPos == -1) {
            painter.drawText(text, this.x, this.y, color);
            this.x += text.length();
            return;
        }
        int prevPos = 0;
        do {
            painter.drawText(text.substring(prevPos, divPos), this.x, this.y, color);
            ++this.y;
            this.x = 0;
        } while ((divPos = text.indexOf(10, prevPos = divPos + 1)) >= 0);
        painter.drawText(text.substring(prevPos, text.length()), this.x, this.y, color);
        this.x = text.length() - prevPos;
    }
}

