/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.security;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class NewPasswordDialog
extends BaseDialog {
    private Text passwordText;
    private Text confirmPasswordText;
    private Button showPasswordCheckbox;
    private String password;

    public NewPasswordDialog(Shell parentShell, String title) {
        super(parentShell, title, null);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Group credGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)"Password", (int)2, (int)768, (int)0);
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Font)credGroup.getFont()) * 20;
        this.passwordText = UIUtils.createLabelText((Composite)credGroup, (String)"Password", (String)"", (int)0x400800, (Object)gd);
        this.confirmPasswordText = UIUtils.createLabelText((Composite)credGroup, (String)"Confirm Password", (String)"", (int)0x400800, (Object)gd);
        ModifyListener checkPassListener = e -> this.getButton(0).setEnabled(!this.passwordText.getText().isEmpty() && this.passwordText.getText().equals(this.confirmPasswordText.getText()));
        this.passwordText.addModifyListener(checkPassListener);
        this.confirmPasswordText.addModifyListener(checkPassListener);
        this.showPasswordCheckbox = UIUtils.createCheckbox((Composite)credGroup, (String)"Show password", (String)"Show password text on screen", (boolean)false, (int)2);
        this.showPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = NewPasswordDialog.this.showPasswordCheckbox.getSelection();
                if (selected) {
                    NewPasswordDialog.this.passwordText.setEchoChar('\u0000');
                    if (NewPasswordDialog.this.confirmPasswordText != null) {
                        NewPasswordDialog.this.confirmPasswordText.setEchoChar('\u0000');
                    }
                } else {
                    NewPasswordDialog.this.passwordText.setEchoChar('*');
                    if (NewPasswordDialog.this.confirmPasswordText != null) {
                        NewPasswordDialog.this.confirmPasswordText.setEchoChar('*');
                    }
                }
            }
        });
        if (this.password != null) {
            this.passwordText.setText(this.password);
        }
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.password = this.passwordText.getText();
        super.okPressed();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static String getNewPassword(Shell shell, String title, String password) {
        NewPasswordDialog dialog = new NewPasswordDialog(shell, title);
        dialog.setPassword(password);
        if (dialog.open() == 0) {
            return dialog.password;
        }
        return null;
    }
}

