/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.timeseries;

import com.dbeaver.ee.model.timeseries.TSDataProvider;
import com.dbeaver.ee.model.timeseries.TSMeasurement;
import com.dbeaver.ee.model.timeseries.TSPoint;
import com.dbeaver.ee.model.timeseries.TSProjection;
import com.dbeaver.ee.runtime.ui.resultset.timeseries.AbstractTimeSeriesPresentation;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.charts.BaseChartDrawingSupplier;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class TimeSeriesGraphPresentation
extends AbstractTimeSeriesPresentation {
    private static final Log log = Log.getLog(TimeSeriesGraphPresentation.class);
    private Object[][] rowData;

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        DBSDataContainer dataContainer = this.getController().getDataContainer();
        TSDataProvider dataProvider = (TSDataProvider)GeneralUtils.adapt((Object)dataContainer, TSDataProvider.class);
        if (dataProvider == null) {
            DBWorkbench.getPlatformUI().showError("No data provider", "Can't obtain time series data provider from " + dataContainer);
            return;
        }
        List allRows = this.getController().getModel().getAllRows();
        this.rowData = new Object[allRows.size()][];
        int i = 0;
        while (i < allRows.size()) {
            this.rowData[i] = ((ResultSetRow)allRows.get(i)).getValues();
            ++i;
        }
        try {
            dataProvider.initData(this.getController().getModel().getAttributes(), this.rowData);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Bad data", "Error settings initial data", (Throwable)e);
            return;
        }
        String seriesName = dataProvider.getSeriesName();
        if (seriesName == null) {
            seriesName = "Time series";
        }
        String measureTitle = "Measures";
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        List measurements = dataProvider.getMeasurements();
        if (measurements.size() == 1) {
            measureTitle = ((TSMeasurement)measurements.get(0)).getName();
        }
        List projections = dataProvider.getProjections(this.rowData);
        for (TSMeasurement measurement : measurements) {
            if (CommonUtils.isEmpty((Collection)projections)) {
                this.loadSeries(dataset, dataProvider, measurement, null);
                continue;
            }
            for (TSProjection projection : projections) {
                this.loadSeries(dataset, dataProvider, measurement, projection);
            }
        }
        JFreeChart xylineChart = ChartFactory.createXYLineChart(null, (String)"Time", (String)measureTitle, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        xylineChart.setBorderVisible(false);
        ChartPanel chartPanel = new ChartPanel(xylineChart);
        chartPanel.setPreferredSize(new Dimension(560, 367));
        XYPlot plot = xylineChart.getXYPlot();
        DateAxis domainAxis = new DateAxis("Time");
        domainAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MM/dd HH:mm"));
        domainAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        domainAxis.setAutoRange(true);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        plot.setDomainAxis((ValueAxis)domainAxis);
        plot.setOutlinePaint(null);
        plot.setShadowGenerator(null);
        plot.setDrawingSupplier((DrawingSupplier)new BaseChartDrawingSupplier());
        LegendTitle legend = xylineChart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        legend.setBorder(0.0, 0.0, 0.0, 0.0);
        this.getChartComposite().setChart(xylineChart);
        this.getChartComposite().setDomainZoomable(false);
        this.getChartComposite().setRangeZoomable(false);
        super.refreshData(refreshMetadata, append, keepState);
    }

    private void loadSeries(TimeSeriesCollection dataset, TSDataProvider dataProvider, TSMeasurement measurement, TSProjection projection) {
        List points;
        try {
            points = dataProvider.getPoints(measurement, projection, this.rowData);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Bad points", "Error reading time series points", (Throwable)e);
            return;
        }
        if (points.isEmpty()) {
            return;
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)(projection == null ? measurement.getName() : projection.toString())));
        for (TSPoint point : points) {
            TimeSeriesDataItem item = new TimeSeriesDataItem((RegularTimePeriod)new FixedMillisecond(point.getX().getTime()), point.getY().doubleValue());
            try {
                series.add(item);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        dataset.addSeries(series);
    }
}

