/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.views;

import com.dbeaver.ee.redis.model.RedisKey;
import com.dbeaver.ee.redis.model.RedisKeyType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectEditorPageControl;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class RedisKeyProperties
extends AbstractDatabaseObjectEditor<RedisKey> {
    private Text keyNameText;
    private Text keyTypeText;
    private Text keyTtlText;

    public void createPartControl(Composite parent) {
        ObjectEditorPageControl editorControl = new ObjectEditorPageControl(parent, 0, (IDatabaseEditor)this);
        Group container = UIUtils.createControlGroup((Composite)editorControl, (String)"Key properties", (int)2, (int)32, (int)-1);
        this.keyNameText = UIUtils.createLabelText((Composite)container, (String)"Key Name", (String)"", (int)2056);
        this.keyTypeText = UIUtils.createLabelText((Composite)container, (String)"Key Type", (String)"", (int)2056);
        this.keyTtlText = UIUtils.createLabelText((Composite)container, (String)"Key TTL", (String)"", (int)2056);
    }

    public void setFocus() {
    }

    public void activatePart() {
        this.getSite().getShell();
        this.keyNameText.setText(((RedisKey)this.getDatabaseObject()).getFullyQualifiedName(DBPEvaluationContext.DML));
        new AbstractJob("Read key properties"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    final RedisKeyType keyType = ((RedisKey)RedisKeyProperties.this.getDatabaseObject()).getKeyType(monitor);
                    final long ttl = ((RedisKey)RedisKeyProperties.this.getDatabaseObject()).getTTL(monitor);
                    UIUtils.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RedisKeyProperties.this.keyTypeText.setText(keyType.name());
                            RedisKeyProperties.this.keyTtlText.setText(String.valueOf(ttl));
                        }
                    });
                }
                catch (Exception e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void refreshPart(Object source, boolean force) {
    }
}

