/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui;

import com.dbeaver.ee.qmdb.model.QMDBEventListener;
import com.dbeaver.ee.qmdb.model.QMDBModel;
import com.dbeaver.ee.qmdb.model.QMDBUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetFilterManager;

public class QMDBResultSetFilterManager
implements IResultSetFilterManager {
    private static final Log log = Log.getLog(QMDBResultSetFilterManager.class);
    private final QMDBModel model;

    public QMDBResultSetFilterManager(QMDBModel model) {
        this.model = model;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public synchronized Collection<String> getQueryFilterHistory(@NotNull String query) throws DBException {
        try {
            QMDBEventListener qmHandler = this.model.getQmHandler();
            if (qmHandler == null) {
                return Collections.emptyList();
            }
            long queryId = qmHandler.getQueryId(query);
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement dbStat = this.model.getConnection().prepareStatement("SELECT FILTER_TEXT FROM " + this.model.getTableName("QM_QUERY_FILTER") + " WHERE QUERY_ID=?");){
                ArrayList<String> arrayList;
                ResultSet dbResult;
                Throwable throwable2;
                block23: {
                    dbStat.setLong(1, queryId);
                    throwable2 = null;
                    Object var9_12 = null;
                    dbResult = dbStat.executeQuery();
                    ArrayList<String> history = new ArrayList<String>();
                    while (dbResult.next()) {
                        history.add(dbResult.getString(1));
                    }
                    arrayList = history;
                    if (dbResult == null) break block23;
                    dbResult.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error getting filter history", (Throwable)e);
        }
    }

    public synchronized void saveQueryFilterValue(@NotNull String query, @NotNull String filterValue) throws DBException {
        try {
            long queryId = this.model.getQmHandler().getQueryId(query);
            long filterHash = QMDBUtils.getHashCode((String)filterValue);
            Throwable throwable = null;
            Object var8_8 = null;
            try (PreparedStatement dbStat = this.model.getConnection().prepareStatement("MERGE INTO " + this.model.getTableName("QM_QUERY_FILTER") + " (QUERY_ID,FILTER_HASH,FILTER_TEXT) " + "KEY (QUERY_ID,FILTER_HASH) VALUES(?,?,?)");){
                dbStat.setLong(1, queryId);
                dbStat.setLong(2, filterHash);
                dbStat.setString(3, filterValue);
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error saving filter history", (Throwable)e);
        }
    }

    public synchronized void deleteQueryFilterValue(@NotNull String query, String filterValue) throws DBException {
        try {
            long queryId = this.model.getQmHandler().getQueryId(query);
            long filterHash = QMDBUtils.getHashCode((String)filterValue);
            Throwable throwable = null;
            Object var8_8 = null;
            try (PreparedStatement dbStat = this.model.getConnection().prepareStatement("DELETE FROM " + this.model.getTableName("QM_QUERY_FILTER") + " WHERE QUERY_ID=? AND FILTER_HASH=?");){
                dbStat.setLong(1, queryId);
                dbStat.setLong(2, filterHash);
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error deleting filter history", (Throwable)e);
        }
    }
}

