/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.views;

import com.dbeaver.ee.mongodb.Activator;
import com.dbeaver.ee.mongodb.MangoDBMessages;
import com.dbeaver.ee.mongodb.MongoUtils;
import com.mongodb.MongoCredential;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class MongoConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    public static final String DATA_ITEM_PASSWORD = "password";
    public static final String PASSWORD_MASK = "***";
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/mongodb_logo.png");
    private Composite settingsGroup;
    private Table seedsTable;
    private Text databaseNameText;
    private Text replicaSetNameText;
    private Combo mechanismCombo;
    private Text userNameText;
    private Text userSourceText;
    private Text passwordText;
    private boolean activated;
    private Button showOtherDatabasesCheck;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite parent) {
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group seedsGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)MangoDBMessages.connection_page_group_address, (int)2, (int)768, (int)-1);
        Composite seedsComposite = UIUtils.createPlaceholder((Composite)seedsGroup, (int)3);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        seedsComposite.setLayoutData((Object)gd);
        this.createSeedsTable(seedsComposite);
        UIUtils.createControlLabel((Composite)seedsGroup, (String)MangoDBMessages.connection_page_label_database);
        Composite dbNameComposite = UIUtils.createComposite((Composite)seedsGroup, (int)2);
        dbNameComposite.setLayoutData((Object)new GridData(768));
        this.databaseNameText = new Text(dbNameComposite, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 270;
        this.databaseNameText.setLayoutData((Object)gd);
        this.showOtherDatabasesCheck = UIUtils.createCheckbox((Composite)dbNameComposite, (String)MangoDBMessages.connection_page_checkbox_show_other_databases, (String)MangoDBMessages.connection_page_checkbox_show_all_server_databases, (boolean)true, (int)1);
        this.replicaSetNameText = UIUtils.createLabelText((Composite)seedsGroup, (String)MangoDBMessages.connection_page_label_text_replica_set, (String)"");
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 270;
        this.replicaSetNameText.setLayoutData((Object)gd);
        Group authGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)MangoDBMessages.connection_page_group_credentials, (int)4, (int)768, (int)-1);
        this.mechanismCombo = UIUtils.createLabelCombo((Composite)authGroup, (String)MangoDBMessages.connection_page_label_combo_mechanism, (int)12);
        this.mechanismCombo.add("NONE");
        this.mechanismCombo.add(MongoCredential.SCRAM_SHA_1_MECHANISM);
        this.mechanismCombo.add(MongoCredential.SCRAM_SHA_256_MECHANISM);
        this.mechanismCombo.add(MongoCredential.MONGODB_CR_MECHANISM);
        this.mechanismCombo.add(MongoCredential.PLAIN_MECHANISM);
        this.mechanismCombo.add(MongoCredential.GSSAPI_MECHANISM);
        this.mechanismCombo.add(MongoCredential.MONGODB_X509_MECHANISM);
        this.mechanismCombo.setLayoutData((Object)new GridData(32));
        UIUtils.createEmptyLabel((Composite)authGroup, (int)2, (int)1);
        this.userNameText = UIUtils.createLabelText((Composite)authGroup, (String)MangoDBMessages.connection_page_label_text_user, (String)"", (int)2048);
        this.userSourceText = UIUtils.createLabelText((Composite)authGroup, (String)MangoDBMessages.connection_page_label_text_source, (String)"", (int)2048);
        this.userSourceText.setToolTipText(MangoDBMessages.connection_page_tool_tip_text_user_source_database);
        this.passwordText = UIUtils.createLabelText((Composite)authGroup, (String)MangoDBMessages.connection_page_label_text_password, (String)"", (int)0x400800);
        this.createPasswordControls((Composite)authGroup, this.passwordText, 2);
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    private void createSeedsTable(Composite seedGroup) {
        this.seedsTable = new Table(seedGroup, 68100);
        this.seedsTable.setHeaderVisible(true);
        GridData gd = new GridData(768);
        gd.minimumHeight = 50;
        gd.heightHint = this.seedsTable.getItemHeight() * 4;
        this.seedsTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.seedsTable, (int)16384, (String)MangoDBMessages.connection_page_table_column_host);
        UIUtils.createTableColumn((Table)this.seedsTable, (int)16384, (String)MangoDBMessages.connection_page_table_column_port);
        this.seedsTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                MongoConnectionPage.this.seedsTable.removeListener(11, (Listener)this);
                UIUtils.packColumns((Table)MongoConnectionPage.this.seedsTable, (boolean)true);
            }
        });
        final CustomTableEditor tableEditor = new CustomTableEditor(this.seedsTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                Text text = new Text((Composite)table, 2048);
                text.setText(item.getText(index));
                text.selectAll();
                return text;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                item.setText(index, ((Text)control).getText());
            }
        };
        Composite btnGroup = UIUtils.createPlaceholder((Composite)seedGroup, (int)1);
        UIUtils.createPushButton((Composite)btnGroup, null, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = new TableItem(MongoConnectionPage.this.seedsTable, 0);
                item.setText(0, "localhost");
                item.setText(1, MongoConnectionPage.this.site.getDriver().getDefaultPort());
                item.setText(2, "local");
                MongoConnectionPage.this.seedsTable.setSelection(item);
                tableEditor.showEditor(item);
                if (MongoConnectionPage.this.activated) {
                    MongoConnectionPage.this.saveAndUpdate();
                }
            }
        });
        UIUtils.createPushButton((Composite)btnGroup, null, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = MongoConnectionPage.this.seedsTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.dispose();
                    ++n2;
                }
            }
        });
    }

    public boolean isComplete() {
        return this.seedsTable.getItemCount() > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void loadSettings() {
        String replicaSet;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.seedsTable != null && this.seedsTable.getItemCount() == 0) {
            String seed;
            String defPort;
            String defHost;
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                defHost = "localhost";
                defPort = this.site.getDriver().getDefaultPort();
            } else {
                defHost = connectionInfo.getHostName();
                defPort = connectionInfo.getHostPort();
            }
            TableItem item = new TableItem(this.seedsTable, 0);
            item.setText(0, defHost);
            item.setText(1, defPort);
            int i = 0;
            while ((seed = connectionInfo.getProviderProperty("seed" + i)) != null) {
                String[] seedTokens = MongoUtils.extractSeedInfo((String)seed);
                TableItem item2 = new TableItem(this.seedsTable, 0);
                item2.setText(0, seedTokens[0]);
                item2.setText(1, seedTokens[1]);
                ++i;
            }
        }
        if (CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            this.databaseNameText.setText("local");
        } else {
            this.databaseNameText.setText(connectionInfo.getDatabaseName());
        }
        if (this.showOtherDatabasesCheck != null) {
            String showOtherDBs = connectionInfo.getProviderProperty("showAllDatabases");
            if (showOtherDBs == null) {
                showOtherDBs = Boolean.TRUE.toString();
            }
            this.showOtherDatabasesCheck.setSelection(CommonUtils.toBoolean((Object)showOtherDBs));
        }
        if ((replicaSet = connectionInfo.getProviderProperty("replicaSet")) != null) {
            this.replicaSetNameText.setText(replicaSet);
        }
        if (this.mechanismCombo != null) {
            String mechanism = connectionInfo.getProviderProperty("@dbeaver-mongo-cred-mechanism@");
            if (mechanism == null) {
                mechanism = "NONE";
            }
            this.mechanismCombo.setText(mechanism);
        }
        String auth = connectionInfo.getProviderProperty("@dbeaver-auth@0");
        String authSource = connectionInfo.getProviderProperty("@dbeaver-auth-source@");
        if (auth != null) {
            String[] authTokens = MongoUtils.extractAuthInfo((String)auth);
            this.userNameText.setText(authTokens[0]);
            this.userSourceText.setText(authTokens[1]);
            this.passwordText.setText(authTokens[2]);
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            this.userNameText.setText(connectionInfo.getUserName());
        }
        if (!CommonUtils.isEmpty((String)authSource)) {
            this.userSourceText.setText(authSource);
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
            this.passwordText.setText(connectionInfo.getUserPassword());
        }
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        Iterator prop = providerProperties.entrySet().iterator();
        while (prop.hasNext()) {
            String propName = (String)prop.next().getKey();
            if (!propName.startsWith("seed") && !propName.startsWith("@dbeaver-auth@")) continue;
            prop.remove();
        }
        int itemIndex = 0;
        TableItem[] tableItemArray = this.seedsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem seedItem = tableItemArray[n2];
            if (itemIndex == 0) {
                connectionInfo.setHostName(seedItem.getText(0));
                connectionInfo.setHostPort(seedItem.getText(1));
            } else {
                connectionInfo.setProviderProperty("seed" + (itemIndex - 1), MongoUtils.saveSeedInfo((String)seedItem.getText(0), (String)seedItem.getText(1)));
            }
            ++itemIndex;
            ++n2;
        }
        connectionInfo.setDatabaseName(this.databaseNameText.getText());
        connectionInfo.setProviderProperty("showAllDatabases", Boolean.valueOf(this.showOtherDatabasesCheck.getSelection()).toString());
        connectionInfo.setProviderProperty("replicaSet", this.replicaSetNameText.getText());
        connectionInfo.setProviderProperty("@dbeaver-mongo-cred-mechanism@", this.mechanismCombo.getText());
        connectionInfo.setUserName(this.userNameText.getText());
        connectionInfo.setProviderProperty("@dbeaver-auth-source@", this.userSourceText.getText());
        connectionInfo.setUserPassword(this.passwordText.getText());
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages(boolean extrasOnly) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

