/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.data.handlers;

import com.dbeaver.ee.mongodb.data.MongoMapValue;
import com.dbeaver.ee.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.ee.mongodb.exec.MongoCustomStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoMapValueHandler
extends MongoBaseValueHandler
implements DBDValueHandlerComposite {
    public static final MongoMapValueHandler INSTANCE = new MongoMapValueHandler();

    @NotNull
    public Class<Map> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Map.class;
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof MongoMapValue) {
            return ((MongoMapValue)((Object)value)).toJson();
        }
        return "#map";
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return new HashMap();
        }
        if (object instanceof Map) {
            return copy ? new HashMap((Map)object) : object;
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    @Override
    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        DBObject columnValue = (DBObject)super.fetchValueObject(session, resultSet, type, index);
        return new MongoMapValue((MongoDataSource)session.getDataSource(), columnValue, null);
    }

    @Override
    protected void bindParameter(MongoSession session, MongoCustomStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) {
        return new MongoMapValue((MongoDataSource)session.getDataSource(), (DBObject)new BasicDBObject(), null);
    }
}

