/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.mockdata.generator;

import com.dbeaver.ui.mockdata.generator.AbstractStringValueGenerator;
import java.io.IOException;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.CommonUtils;

public class StringTextGenerator
extends AbstractStringValueGenerator {
    private String templateString;
    private int minLength = 1;
    private int maxLength = 100;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        Integer max;
        super.init(container, attribute, properties);
        this.templateString = CommonUtils.toString((Object)properties.get("template"));
        if (this.templateString == null) {
            throw new DBCException("Empty template string for simple string generator");
        }
        Integer min = (Integer)properties.get("minLength");
        if (min != null) {
            this.minLength = min;
        }
        if (this.minLength > this.templateString.length()) {
            this.minLength = this.templateString.length();
        }
        if ((max = (Integer)properties.get("maxLength")) != null) {
            this.maxLength = max;
        }
        if (this.maxLength == 0 || attribute.getMaxLength() > 0L && (long)this.maxLength > attribute.getMaxLength()) {
            this.maxLength = (int)attribute.getMaxLength();
        }
        if (this.maxLength > this.templateString.length()) {
            this.maxLength = this.templateString.length();
        }
        if (this.minLength > this.maxLength) {
            this.maxLength = this.minLength;
        }
    }

    @Override
    public void nextRow() {
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        int length = this.minLength + this.random.nextInt(this.maxLength - this.minLength + 1);
        int tplLength = this.templateString.length();
        int start = this.random.nextInt(tplLength);
        if (start > 0) {
            int wordStart = start;
            while (wordStart < tplLength && !Character.isWhitespace(this.templateString.charAt(wordStart - 1))) {
                ++wordStart;
            }
            if (wordStart < tplLength) {
                start = wordStart;
            }
        }
        if (start + length < tplLength) {
            return this.tune(this.templateString.substring(start, start + length));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.templateString.substring(start));
        int newlength = length - (tplLength - start);
        int i = 0;
        while (i < newlength / tplLength) {
            sb.append(this.templateString);
            ++i;
        }
        sb.append(this.templateString.substring(0, newlength % tplLength));
        return this.tune(sb.toString().trim());
    }
}

