/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.model.data.spatial;

import com.dbeaver.db.oracle.model.data.spatial.CoordinateAccess;
import com.dbeaver.db.oracle.model.data.spatial.CoordinateAccessFactory;
import com.dbeaver.db.oracle.model.data.spatial.SDOAttributeList;
import com.dbeaver.db.oracle.model.data.spatial.SDOOrdinateList;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;

public class SDOCoordinates {
    private SDOCoordinates() {
    }

    public static CoordinateSequence subList(CoordinateSequenceFactory factory, CoordinateSequence sequence, int fromIndex, int toIndex) {
        List sublist;
        if (fromIndex == 0 && toIndex == sequence.size()) {
            return sequence;
        }
        if (sequence instanceof List && (sublist = ((List)sequence).subList(fromIndex, toIndex)) instanceof CoordinateSequence) {
            return (CoordinateSequence)sublist;
        }
        if (sequence instanceof CoordinateAccess) {
            CoordinateAccess access = (CoordinateAccess)sequence;
            double[][] coordArray = access.toOrdinateArrays();
            Object[] attributeArray = access.toAttributeArrays();
            double[][] subCoordArray = new double[access.getDimension()][];
            Object[][] subAttributeArray = new Object[access.getNumAttributes()][];
            int i = 0;
            while (i < access.getDimension()) {
                subCoordArray[i] = new SDOOrdinateList(coordArray[i], 0, 1, fromIndex, toIndex).toDoubleArray();
                ++i;
            }
            i = 0;
            while (i < access.getNumAttributes()) {
                subAttributeArray[i] = new SDOAttributeList(attributeArray[i], 0, 1, fromIndex, toIndex).toObjectArray();
                ++i;
            }
            CoordinateAccess c = ((CoordinateAccessFactory)factory).create(subCoordArray, (Object[])subAttributeArray);
            return c;
        }
        int size = toIndex - fromIndex;
        CoordinateSequence newSeq = SDOCoordinates.createCS(factory, size, sequence.getDimension());
        CoordinateSequences.copy((CoordinateSequence)sequence, (int)fromIndex, (CoordinateSequence)newSeq, (int)0, (int)size);
        return newSeq;
    }

    public static CoordinateSequence reverse(CoordinateSequenceFactory factory, CoordinateSequence sequence) {
        if (sequence instanceof CoordinateAccess) {
            CoordinateAccess access = (CoordinateAccess)sequence;
            double[][] coordArray = access.toOrdinateArrays();
            Object[] attributeArray = access.toAttributeArrays();
            double[][] subCoordArray = new double[access.getDimension()][];
            Object[][] subAttributeArray = new Object[access.getNumAttributes()][];
            int i = 0;
            while (i < access.getDimension()) {
                subCoordArray[i] = new SDOOrdinateList(coordArray[i], 0, 1, access.size() - 1, -1).toDoubleArray();
                ++i;
            }
            i = 0;
            while (i < access.getNumAttributes()) {
                subAttributeArray[i] = new SDOAttributeList(attributeArray[i], 0, 1, access.size() - 1, -1).toObjectArray();
                ++i;
            }
            CoordinateAccess c = ((CoordinateAccessFactory)factory).create(subCoordArray, (Object[])subAttributeArray);
            return c;
        }
        CoordinateSequence revSeq = factory.create(sequence);
        CoordinateSequences.reverse((CoordinateSequence)revSeq);
        return revSeq;
    }

    public static String toString(CoordinateSequence cs, int coordinate, NumberFormat nf) {
        StringBuffer buf = new StringBuffer();
        SDOCoordinates.append(buf, cs, coordinate, nf);
        return buf.toString();
    }

    public static void append(StringBuffer buf, CoordinateSequence cs, int coordinate, NumberFormat nf) {
        if (cs instanceof CoordinateAccess) {
            CoordinateAccess ca = (CoordinateAccess)cs;
            SDOCoordinates.append(buf, ca, coordinate, SDOCoordinates.LEN(ca), nf);
        } else {
            SDOCoordinates.append(buf, cs, coordinate, SDOCoordinates.LEN(cs), nf);
        }
    }

    public static void append(StringBuffer buf, CoordinateSequence cs, int coordinate, int LEN, NumberFormat nf) {
        Coordinate c = cs.getCoordinate(coordinate);
        buf.append(nf.format(c.x));
        buf.append(" ");
        buf.append(nf.format(c.y));
        if (LEN == 3) {
            buf.append(" ");
            buf.append(nf.format(c.z));
        }
    }

    public static void append(StringBuffer buf, CoordinateAccess ca, int coordinate, int LEN, NumberFormat nf) {
        buf.append(nf.format(ca.getOrdinate(coordinate, 0)));
        int i = 1;
        while (i < LEN) {
            buf.append(" ");
            buf.append(nf.format(ca.getOrdinate(coordinate, i)));
            ++i;
        }
    }

    public static int LEN(CoordinateSequence cs) {
        return SDOCoordinates.D(cs) + SDOCoordinates.L(cs);
    }

    public static int D(CoordinateSequence cs) {
        if (cs instanceof CoordinateAccess) {
            return ((CoordinateAccess)cs).getDimension();
        }
        if (cs.size() > 0) {
            return Double.isNaN(cs.getCoordinate((int)0).z) ? 2 : 3;
        }
        return 3;
    }

    public static int L(CoordinateSequence cs) {
        if (cs instanceof CoordinateAccess) {
            return ((CoordinateAccess)cs).getNumAttributes();
        }
        return 0;
    }

    public static NumberFormat format(PrecisionModel pm) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setNaN("NaN");
        DecimalFormat f = new DecimalFormat();
        f.setDecimalFormatSymbols(symbols);
        if (pm == null) {
            f.setMaximumFractionDigits(0);
            return f;
        }
        f.setMinimumFractionDigits(0);
        f.setMaximumFractionDigits(pm.getMaximumSignificantDigits());
        return f;
    }

    public static String toString(CoordinateSequence cs, PrecisionModel pm) {
        StringBuffer buf = new StringBuffer();
        SDOCoordinates.append(buf, cs, SDOCoordinates.format(pm));
        return buf.toString();
    }

    public static void append(StringBuffer buf, CoordinateSequence cs, NumberFormat nf) {
        if (cs instanceof CoordinateAccess) {
            SDOCoordinates.append(buf, (CoordinateAccess)cs, nf);
        } else {
            int LEN = SDOCoordinates.LEN(cs);
            if (cs.size() == 0) {
                return;
            }
            SDOCoordinates.append(buf, cs, 0, LEN, nf);
            if (cs.size() == 1) {
                return;
            }
            int i = 1;
            while (i < cs.size()) {
                buf.append(", ");
                SDOCoordinates.append(buf, cs, i, LEN, nf);
                ++i;
            }
        }
    }

    public static void append(StringBuffer buf, CoordinateAccess ca, NumberFormat nf) {
        int LEN = SDOCoordinates.LEN(ca);
        if (ca.size() == 0) {
            return;
        }
        SDOCoordinates.append(buf, ca, 0, LEN, nf);
        if (ca.size() == 1) {
            return;
        }
        int i = 1;
        while (i < ca.size()) {
            buf.append(", ");
            SDOCoordinates.append(buf, ca, i, LEN, nf);
            ++i;
        }
    }

    public static CoordinateSequence createCS(CoordinateSequenceFactory csFactory, int size, int dimension) {
        return SDOCoordinates.createCS(csFactory, size, dimension, 0);
    }

    public static CoordinateSequence createCS(CoordinateSequenceFactory csFactory, int size, int dimension, int measures) {
        Object cs = csFactory instanceof CoordinateArraySequenceFactory && dimension == 1 ? new CoordinateArraySequence(size, dimension, measures) : csFactory.create(size, dimension, measures);
        if (cs.getDimension() != dimension) {
            throw new IllegalStateException("Unable to use" + csFactory + " to produce CoordinateSequence with dimension " + dimension);
        }
        return cs;
    }
}

