/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.model.plan;

import com.dbeaver.db.mssql.model.plan.SQLServerExecutionPlan;
import com.dbeaver.db.mssql.model.plan.SQLServerPlanNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.utils.CommonUtils;

public class SQLServerQueryPlanner
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    private final DBPDataSource dataSource;
    private static final String FORMAT_VERSION = "1";

    public SQLServerQueryPlanner(DBPDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query) throws DBException {
        SQLServerExecutionPlan plan = new SQLServerExecutionPlan(query);
        plan.explain(session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    public void serialize(Writer planData, DBCPlan plan) throws IOException, InvocationTargetException {
        this.serializeJson(planData, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return SQLServerQueryPlanner.FORMAT_VERSION;
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonArray attributes = new JsonArray();
                if (node instanceof SQLServerPlanNode) {
                    SQLServerPlanNode sqlNode = (SQLServerPlanNode)node;
                    for (Map.Entry<String, String> e : sqlNode.attributes.entrySet()) {
                        JsonObject attr = new JsonObject();
                        attr.add(e.getKey(), (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)e.getValue())));
                        attributes.add((JsonElement)attr);
                    }
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    public DBCPlan deserialize(Reader planData) throws IOException, InvocationTargetException {
        try {
            JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
            String query = this.getQuery(jo);
            ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
            List rootNodes = loader.loadRoot(this.dataSource, jo, (datasource, node, parent) -> {
                SQLServerPlanNode nodeMSSQL = new SQLServerPlanNode((SQLServerPlanNode)parent, node);
                return nodeMSSQL;
            });
            return new SQLServerExecutionPlan(query, rootNodes);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

