/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Pong;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class InfluxExecutionContext
extends AbstractExecutionContext<InfluxDataSource> {
    private static final Log log = Log.getLog(InfluxExecutionContext.class);
    private InfluxDB influxDB;
    private InfluxDB.ConsistencyLevel currentConsistencyLevel = InfluxDB.ConsistencyLevel.ONE;

    public InfluxExecutionContext(InfluxDataSource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((InfluxDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open influx session");
                DBPConnectionConfiguration configuration = ((InfluxDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
                this.influxDB = InfluxDBFactory.connect((String)configuration.getUrl(), (String)configuration.getUserName(), (String)configuration.getUserPassword());
                this.influxDB.ping();
                String defCL = ((InfluxDataSource)this.dataSource).getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-default.consistency.level@");
                if (!CommonUtils.isEmpty((String)defCL)) {
                    try {
                        this.currentConsistencyLevel = InfluxDB.ConsistencyLevel.valueOf((String)defCL);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.debug((Object)("Bad default consistency level: " + defCL));
                    }
                }
                this.influxDB.setConsistency(this.currentConsistencyLevel);
                super.initContextBootstrap(monitor, true);
                ((InfluxDataSource)this.dataSource).addExecutionContext(this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, this.dataSource);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((InfluxDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public InfluxSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new InfluxSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            Pong pong = this.influxDB.ping();
            pong.getVersion();
        }
        catch (Exception e) {
            throw new DBException("Error pinging Influx", (Throwable)e);
        }
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.influxDB.close();
        InfluxExecutionContext influxExecutionContext = this;
        synchronized (influxExecutionContext) {
            ((InfluxDataSource)this.dataSource).removeExecutionContext(this);
            super.closeContext();
        }
    }

    public InfluxDB.ConsistencyLevel getCurrentConsistencyLevel() {
        return this.currentConsistencyLevel;
    }

    public void setCurrentConsistencyLevel(InfluxDB.ConsistencyLevel currentConsistencyLevel) {
        this.currentConsistencyLevel = currentConsistencyLevel;
        this.influxDB.setConsistency(this.currentConsistencyLevel);
    }
}

