/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.views;

import com.dbeaver.ee.influxdb.Activator;
import com.dbeaver.ee.influxdb.InfluxDBMessages;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.influxdb.InfluxDB;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class InfluxConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/influxdb_logo.png");
    private Composite settingsGroup;
    private Text hostText;
    private Text portText;
    private Text databaseText;
    private Text userText;
    private Text passwordText;
    private Button userSSLCheck;
    private Combo defConsistencyLevel;
    private boolean activated;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)InfluxDBMessages.connection_page_control_group_server, (int)4, (int)768, (int)-1);
        this.hostText = UIUtils.createLabelText((Composite)serverGroup, (String)InfluxDBMessages.connection_page_label_text_host, (String)"");
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)serverGroup, (String)InfluxDBMessages.connection_page_label_text_port, (String)"");
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.databaseText = UIUtils.createLabelText((Composite)serverGroup, (String)InfluxDBMessages.connection_page_label_text_database, (String)"");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.databaseText.setLayoutData((Object)gd);
        this.databaseText.addModifyListener(textListener);
        Group securityGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)InfluxDBMessages.connection_page_control_group_security, (int)4, (int)32, (int)-1);
        this.userText = UIUtils.createLabelText((Composite)securityGroup, (String)InfluxDBMessages.connection_page_label_text_user_name, (String)"user", (int)2048);
        gd = new GridData(32);
        gd.widthHint = 200;
        gd.horizontalSpan = 3;
        this.userText.setLayoutData((Object)gd);
        this.userText.addModifyListener(textListener);
        this.passwordText = UIUtils.createLabelText((Composite)securityGroup, (String)InfluxDBMessages.connection_page_label_text_password, (String)"", (int)0x400800);
        gd = new GridData(32);
        gd.widthHint = 200;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        this.createPasswordControls((Composite)securityGroup, this.passwordText, 2);
        this.userSSLCheck = UIUtils.createCheckbox((Composite)securityGroup, (String)InfluxDBMessages.connection_page_checkbox_use_ssl, (String)InfluxDBMessages.connection_page_checkbox_tip_use_ssl, (boolean)false, (int)4);
        Group miscGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)InfluxDBMessages.connection_page_control_group_misc, (int)2, (int)768, (int)0);
        this.defConsistencyLevel = UIUtils.createLabelCombo((Composite)miscGroup, (String)InfluxDBMessages.connection_page_label_combo_default_consistency_level, (String)InfluxDBMessages.connection_page_label_combo_tip_consistency_level, (int)12);
        InfluxDB.ConsistencyLevel[] consistencyLevelArray = InfluxDB.ConsistencyLevel.values();
        int n = consistencyLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            InfluxDB.ConsistencyLevel cl = consistencyLevelArray[n2];
            this.defConsistencyLevel.add(cl.name());
            ++n2;
        }
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    public boolean isComplete() {
        return !this.hostText.getText().isEmpty() && !this.portText.getText().isEmpty() && !this.userText.getText().isEmpty();
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            } else {
                this.hostText.setText("localhost");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                this.databaseText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            } else {
                this.databaseText.setText("");
            }
            if (connectionInfo.getUserName() != null) {
                this.userText.setText(connectionInfo.getUserName());
            }
            if (connectionInfo.getUserPassword() != null) {
                this.passwordText.setText(connectionInfo.getUserPassword());
            }
            this.userSSLCheck.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-influxdb.use.ssl"), (boolean)false));
            String clName = CommonUtils.toString((Object)connectionInfo.getProviderProperty("@dbeaver-default.consistency.level@"));
            if (CommonUtils.isEmpty((String)clName)) {
                this.defConsistencyLevel.setText(InfluxDB.ConsistencyLevel.ONE.name());
            } else {
                this.defConsistencyLevel.setText(clName);
            }
        }
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
            connectionInfo.setHostPort(this.portText.getText().trim());
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
            connectionInfo.setUserName(this.userText.getText());
            connectionInfo.setUserPassword(this.passwordText.getText());
            connectionInfo.setProviderProperty("@dbeaver-influxdb.use.ssl", String.valueOf(this.userSSLCheck.getSelection()));
            connectionInfo.setProviderProperty("@dbeaver-default.consistency.level@", String.valueOf(this.defConsistencyLevel.getText()));
        }
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages(boolean extrasOnly) {
        return new IDialogPage[0];
    }
}

