/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import java.util.Map;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.jkiss.dbeaver.model.exec.DBCException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;

public class DynamoSQL {
    public static void parseExpression(Map<String, Condition> conditions, Expression expr) throws DBCException {
        if (expr instanceof AndExpression) {
            DynamoSQL.parseExpression(conditions, ((AndExpression)expr).getLeftExpression());
            DynamoSQL.parseExpression(conditions, ((AndExpression)expr).getRightExpression());
        } else {
            if (expr instanceof InExpression) {
                throw new DBCException("IN conditions not supported: " + expr);
            }
            if (expr instanceof OrExpression) {
                throw new DBCException("OR conditions not supported: " + expr);
            }
            if (expr instanceof BinaryExpression) {
                DynamoSQL.parseBinaryExpression(conditions, (BinaryExpression)expr);
            } else if (expr instanceof Parenthesis) {
                DynamoSQL.parseExpression(conditions, ((Parenthesis)expr).getExpression());
            } else {
                throw new DBCException("Unsupported expression: " + expr);
            }
        }
    }

    private static void parseBinaryExpression(Map<String, Condition> conditions, BinaryExpression expr) throws DBCException {
        ComparisonOperator operator;
        Expression left = expr.getLeftExpression();
        if (!(left instanceof Column)) {
            throw new DBCException("Unsupported left operand: " + left);
        }
        Column column = (Column)left;
        String fieldName = DynamoSQL.unquote(column.getFullyQualifiedName());
        Object fieldValue = DynamoSQL.parseValueExpression(expr.getRightExpression());
        if (expr instanceof EqualsTo) {
            operator = ComparisonOperator.EQ;
        } else if (expr instanceof NotEqualsTo) {
            operator = ComparisonOperator.NE;
        } else if (expr instanceof GreaterThan) {
            operator = ComparisonOperator.GT;
        } else if (expr instanceof GreaterThanEquals) {
            operator = ComparisonOperator.GE;
        } else if (expr instanceof MinorThan) {
            operator = ComparisonOperator.LT;
        } else if (expr instanceof MinorThanEquals) {
            operator = ComparisonOperator.LT;
        } else {
            throw new DBCException("Unsupported operation: " + expr.getStringExpression());
        }
        DynamoSQL.makeObjectCondition(conditions, fieldName, fieldValue, operator);
    }

    private static void makeObjectCondition(Map<String, Condition> conditions, String fieldName, Object fieldValue, ComparisonOperator operator) {
        conditions.put(fieldName, (Condition)Condition.builder().attributeValueList(new AttributeValue[]{DynamoDBUtils.getAttributeValue(fieldValue)}).comparisonOperator(operator).build());
    }

    private static Object parseValueExpression(Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = DynamoSQL.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + expr);
        }
        throw new DBCException("Unsupported value: " + expr);
    }

    public static String unquote(String name) {
        return name.replace("\"", "");
    }
}

