/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoScanStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class DynamoResultSet
extends AbstractResultSet<DynamoSession, DynamoBaseStatement>
implements DBCResultSetSampleProvider {
    private final List<Map<String, AttributeValue>> items;
    private DBCResultSetMetaData metaData;
    private int itemNumber;

    public DynamoResultSet(DynamoBaseStatement statement, ScanResponse scanResponse) {
        super((DBCSession)((DynamoSession)statement.getSession()), (DBCStatement)statement);
        this.items = scanResponse.items();
        this.itemNumber = -1;
    }

    public DynamoResultSet(DynamoBaseStatement statement, QueryResponse queryResponse) {
        super((DBCSession)((DynamoSession)statement.getSession()), (DBCStatement)statement);
        this.items = queryResponse.items();
        this.itemNumber = -1;
    }

    public DynamoSession getSession() {
        return (DynamoSession)((DynamoBaseStatement)this.statement).getSession();
    }

    public DynamoBaseStatement getSourceStatement() {
        return (DynamoBaseStatement)this.statement;
    }

    private void checkRowFetched() throws DBCException {
        if (this.itemNumber < 0) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        Map<String, AttributeValue> valueMap = this.items.get(this.itemNumber);
        if (index == 0) {
            return new DynamoDocument(this.getSession().getDataSource(), this.statement instanceof DynamoScanStatement ? ((DynamoScanStatement)this.statement).getTable() : null, valueMap);
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return new DynamoDocument(this.getSession().getDataSource(), this.statement instanceof DynamoScanStatement ? ((DynamoScanStatement)this.statement).getTable() : null, this.items.get(this.itemNumber));
    }

    public boolean nextRow() throws DBCException {
        if (this.items.size() - 1 > this.itemNumber) {
            ++this.itemNumber;
            return true;
        }
        return false;
    }

    public boolean moveTo(int position) throws DBCException {
        this.itemNumber = position - 1;
        return true;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = new LocalResultSetMeta(Collections.singletonList(new DynamicDocumentAttribute()));
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        return null;
    }

    public void close() {
    }

    private DBCEntityMetaData makeEntityMetaData(DBCAttributeMetaData attributeMeta) {
        return new DocumentEntityMetaData(attributeMeta);
    }

    @NotNull
    public List<Object[]> getSampleRows(DBCSession session, int maxRows) throws DBCException {
        ArrayList<Object[]> sample = new ArrayList<Object[]>();
        while (this.nextRow() && maxRows-- > 0 && !session.getProgressMonitor().isCanceled()) {
            sample.add(new Object[]{this.getAttributeValue(0)});
        }
        this.moveTo(0);
        return sample;
    }

    private class DocumentEntityMetaData
    implements DBCEntityMetaData {
        private final DBCAttributeMetaData attributeMeta;

        DocumentEntityMetaData(DBCAttributeMetaData attributeMeta) {
            this.attributeMeta = attributeMeta;
        }

        public String getCatalogName() {
            return null;
        }

        public String getSchemaName() {
            return null;
        }

        @NotNull
        public String getEntityName() {
            return ((DynamoBaseStatement)DynamoResultSet.this.statement).getEntityName();
        }

        @NotNull
        public List<? extends DBCAttributeMetaData> getAttributes() {
            return Collections.singletonList(this.attributeMeta);
        }
    }

    public class DynamicDocumentAttribute
    implements DBCAttributeMetaData {
        public String getFullTypeName() {
            return this.getTypeName();
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public boolean isReadOnly() {
            return true;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return DynamoResultSet.this.makeEntityMetaData(this);
        }

        @NotNull
        public String getName() {
            return "DynamoItem";
        }

        public String getTypeName() {
            return "json";
        }

        public int getTypeID() {
            return 0;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.DOCUMENT;
        }

        public int getOrdinalPosition() {
            return 0;
        }

        public Object getSource() {
            return DynamoResultSet.this.statement;
        }

        @NotNull
        public String getLabel() {
            return this.getName();
        }

        public String getEntityName() {
            return ((DynamoBaseStatement)DynamoResultSet.this.statement).getEntityName();
        }
    }
}

