/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.model;

import com.dbeaver.db.google.bigtable.model.BigTableDataSourceInfo;
import com.dbeaver.db.google.bigtable.model.BigTableDataType;
import com.dbeaver.db.google.bigtable.model.BigTableInstance;
import com.dbeaver.db.google.bigtable.model.BigTableSQLDialect;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.CommonUtils;

public class BigTableDataSource
implements DBPDataSource,
SQLDataSource,
DBSObjectContainer,
DBSObject,
DBSObjectSelector,
DBPRefreshableObject,
DBPDataTypeProvider,
IAdaptable {
    private static final Log log = Log.getLog(BigTableDataSource.class);
    @NotNull
    private final DBPDataSourceContainer container;
    private BigTableDataSourceInfo info;
    private final String projectID;
    private final InstanceCache instances = new InstanceCache();
    private final List<BigTableDataType> dataTypes = new ArrayList<BigTableDataType>();
    private CredentialsProvider credentialsProvider;
    private BigtableInstanceAdminClient instanceAdminClient;
    private String activeInstanceID;

    public BigTableDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        this.container = container;
        DBPConnectionConfiguration configuration = container.getActualConnectionConfiguration();
        this.projectID = container.getActualConnectionConfiguration().getProviderProperty("projectId");
        if (CommonUtils.isEmpty((String)this.projectID)) {
            throw new DBException("Empty project ID");
        }
        this.activeInstanceID = container.getActualConnectionConfiguration().getServerName();
        this.credentialsProvider = this.setupCredentials(configuration);
        try {
            this.instanceAdminClient = BigtableInstanceAdminClient.create((BigtableInstanceAdminSettings)BigtableInstanceAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider).setProjectId(this.projectID).build());
        }
        catch (IOException e) {
            throw new DBException("Error instantiating instance admin client", (Throwable)e);
        }
        this.instances.getAllObjects(monitor, this);
        BigTableDataType.TypeName[] typeNameArray = BigTableDataType.TypeName.values();
        int n = typeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            BigTableDataType.TypeName typeName = typeNameArray[n2];
            this.dataTypes.add(new BigTableDataType(this, typeName));
            ++n2;
        }
    }

    private CredentialsProvider setupCredentials(DBPConnectionConfiguration cfg) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream cfgFileStream = new FileInputStream(CommonUtils.toString((Object)cfg.getProviderProperty("credentialsFile")));){
                return FixedCredentialsProvider.create((Credentials)ServiceAccountCredentials.fromStream((InputStream)cfgFileStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Can't read configuration", (Throwable)e);
        }
    }

    public String getProjectID() {
        return this.projectID;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public BigtableInstanceAdminClient getInstanceAdminClient() {
        return this.instanceAdminClient;
    }

    public SQLDialect getSQLDialect() {
        return BigTableSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new BigTableDataSourceInfo(this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @NotNull
    public BigTableInstance getDefaultInstance() {
        if (CommonUtils.isEmpty((String)this.activeInstanceID)) {
            List instanceList = this.instances.getCachedObjects();
            if (!instanceList.isEmpty()) {
                return (BigTableInstance)instanceList.get(0);
            }
            throw new IllegalStateException("No BigTable instances found");
        }
        BigTableInstance defInstance = (BigTableInstance)this.instances.getCachedObject(this.activeInstanceID);
        if (defInstance == null) {
            throw new IllegalStateException("Instance '" + this.activeInstanceID + "' not found");
        }
        return defInstance;
    }

    @NotNull
    public List<BigTableInstance> getAvailableInstances() {
        return this.instances.getCachedObjects();
    }

    public void shutdown(DBRProgressMonitor monitor) {
        if (this.instanceAdminClient != null) {
            this.instanceAdminClient.close();
            this.instanceAdminClient = null;
        }
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this;
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.instances.getAllObjects(monitor, this);
    }

    public BigTableInstance getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (BigTableInstance)this.instances.getObject(monitor, this, childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return BigTableInstance.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public List<BigTableInstance> getInstances() {
        return this.getAvailableInstances();
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        for (BigTableDataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType.getDataKind();
        }
        return DBPDataKind.OBJECT;
    }

    public BigTableDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.getLocalDataType(typeFullName);
    }

    public List<BigTableDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public BigTableDataType getLocalDataType(String typeName) {
        for (BigTableDataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType;
        }
        return null;
    }

    public BigTableDataType getLocalDataType(int typeID) {
        for (BigTableDataType dataType : this.dataTypes) {
            if (dataType.getTypeID() != typeID) continue;
            return dataType;
        }
        return null;
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return BigTableDataType.TypeName.VALUE.getTypeName();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    @Nullable
    public BigTableInstance getDefaultObject() {
        return this.getDefaultInstance();
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        BigTableInstance oldDefaultObject = this.getDefaultObject();
        this.activeInstanceID = object.getName();
        if (oldDefaultObject != null) {
            DBUtils.fireObjectSelect((DBSObject)oldDefaultObject, (boolean)false);
        }
        if (this.activeInstanceID != null) {
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        return false;
    }

    class InstanceCache
    extends BasicObjectCache<BigTableDataSource, BigTableInstance> {
        InstanceCache() {
        }

        @NotNull
        public Collection<BigTableInstance> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable BigTableDataSource bigTableDataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<BigTableInstance> instanceList = new ArrayList<BigTableInstance>();
                for (Instance instance : BigTableDataSource.this.instanceAdminClient.listInstances()) {
                    BigTableInstance btInstance = new BigTableInstance(monitor, BigTableDataSource.this, instance);
                    instanceList.add(btInstance);
                }
                this.setCache(instanceList);
            }
            return this.getCachedObjects();
        }
    }
}

