/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.ILaunchHistoryChangedListener;
import org.eclipse.debug.internal.ui.ILaunchLabelChangedListener;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.contextlaunching.LaunchingResourceManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutSelectionDialog;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.actions.AbstractLaunchToolbarAction;
import org.eclipse.debug.ui.actions.LaunchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public abstract class AbstractLaunchHistoryAction
implements IActionDelegate2,
IWorkbenchWindowPulldownDelegate2,
ILaunchHistoryChangedListener {
    private Menu fMenu;
    private IAction fAction;
    private ILaunchGroup fLaunchGroup = null;
    protected boolean fRecreateMenu = false;
    private ILaunchLabelChangedListener fLabelListener = new ILaunchLabelChangedListener(){

        @Override
        public ILaunchGroup getLaunchGroup() {
            return AbstractLaunchHistoryAction.this.fLaunchGroup;
        }

        @Override
        public void labelChanged() {
            AbstractLaunchHistoryAction.this.updateTooltip();
        }
    };

    public AbstractLaunchHistoryAction(String launchGroupIdentifier) {
        this.fLaunchGroup = this.getLaunchConfigurationManager().getLaunchGroup(launchGroupIdentifier);
    }

    private void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void addToMenu(Menu menu, IAction action, int accelerator) {
        StringBuilder label = new StringBuilder();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }

    private void initialize(IAction action) {
        this.getLaunchConfigurationManager().addLaunchHistoryListener(this);
        this.setAction(action);
        this.updateTooltip();
        action.setEnabled(this.existsConfigTypesForMode());
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes;
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int n = configTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType configType = iLaunchConfigurationTypeArray[n2];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void updateTooltip() {
        this.getAction().setToolTipText(this.getToolTip());
    }

    protected String getToolTip(ILaunchConfiguration configuration) {
        String launchName = configuration.getName();
        String mode = this.getMode();
        String label = mode.equals("run") ? ActionMessages.AbstractLaunchHistoryAction_1 : (mode.equals("debug") ? ActionMessages.AbstractLaunchHistoryAction_2 : (mode.equals("profile") ? ActionMessages.AbstractLaunchHistoryAction_3 : ActionMessages.AbstractLaunchHistoryAction_4));
        return MessageFormat.format((String)ActionMessages.AbstractLaunchHistoryAction_0, (Object[])new Object[]{label, launchName});
    }

    private String getToolTip() {
        String launchName = DebugUIPlugin.getDefault().getLaunchingResourceManager().getLaunchLabel(this.fLaunchGroup);
        if (launchName == null) {
            return DebugUIPlugin.removeAccelerators(this.internalGetHistory().getLaunchGroup().getLabel());
        }
        String label = null;
        String mode = this.getMode();
        label = mode.equals("run") ? ActionMessages.AbstractLaunchHistoryAction_1 : (mode.equals("debug") ? ActionMessages.AbstractLaunchHistoryAction_2 : (mode.equals("profile") ? ActionMessages.AbstractLaunchHistoryAction_3 : ActionMessages.AbstractLaunchHistoryAction_4));
        if ("".equals(launchName)) {
            return MessageFormat.format((String)ActionMessages.AbstractLaunchHistoryAction_5, (Object[])new Object[]{label});
        }
        return MessageFormat.format((String)ActionMessages.AbstractLaunchHistoryAction_0, (Object[])new Object[]{label, launchName});
    }

    @Override
    public void launchHistoryChanged() {
        this.fRecreateMenu = true;
    }

    public void dispose() {
        this.setMenu(null);
        this.getLaunchConfigurationManager().removeLaunchHistoryListener(this);
        DebugUIPlugin.getDefault().getLaunchingResourceManager().removeLaunchLabelChangedListener(this.fLabelListener);
    }

    protected ILaunchConfiguration getLastLaunch() {
        return this.getLaunchConfigurationManager().getFilteredLastLaunch(this.getLaunchGroupIdentifier());
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu();
        return this.fMenu;
    }

    private void initMenu() {
        this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (AbstractLaunchHistoryAction.this.fRecreateMenu) {
                    MenuItem[] items;
                    Menu m = (Menu)e.widget;
                    MenuItem[] menuItemArray = items = m.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    AbstractLaunchHistoryAction.this.fillMenu(m);
                    AbstractLaunchHistoryAction.this.fRecreateMenu = false;
                }
            }
        });
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }

    protected void fillMenu(Menu menu) {
        LaunchAction action;
        ILaunchConfiguration launch;
        ILaunchConfiguration[] historyList = this.getHistory();
        ILaunchConfiguration[] favoriteList = this.getFavorites();
        int accelerator = 1;
        ILaunchConfiguration[] iLaunchConfigurationArray = favoriteList;
        int n = favoriteList.length;
        int n2 = 0;
        while (n2 < n) {
            launch = iLaunchConfigurationArray[n2];
            action = new LaunchAction(launch, this.getMode());
            this.addToMenu(menu, (IAction)action, accelerator);
            ++accelerator;
            ++n2;
        }
        if (favoriteList.length > 0 && historyList.length > 0) {
            this.addSeparator(menu);
        }
        iLaunchConfigurationArray = historyList;
        n = historyList.length;
        n2 = 0;
        while (n2 < n) {
            launch = iLaunchConfigurationArray[n2];
            action = new LaunchAction(launch, this.getMode());
            this.addToMenu(menu, (IAction)action, accelerator);
            ++accelerator;
            ++n2;
        }
        if (accelerator == 1) {
            Action action2 = new Action(ActionMessages.AbstractLaunchHistoryAction_6){};
            action2.setEnabled(false);
            ActionContributionItem item = new ActionContributionItem((IAction)action2);
            item.fill(menu, -1);
        }
    }

    protected void addSeparator(Menu menu) {
        new MenuItem(menu, 2);
    }

    public void run(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        if ((event.stateMask & SWT.MOD1) > 0 && event.type != 1) {
            ILaunchConfiguration configuration = null;
            String groupid = this.getLaunchGroupIdentifier();
            configuration = LaunchingResourceManager.isContextLaunchEnabled(groupid) ? this.resolveContextConfiguration() : this.getLaunchConfigurationManager().getFilteredLastLaunch(groupid);
            ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>(1);
            if (configuration != null) {
                configs.add(configuration);
            }
            DebugUIPlugin.openLaunchConfigurationsDialog(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection(configs), groupid, true);
            return;
        }
        this.runInternal(action, (event.stateMask & 0x20000) > 0);
    }

    protected void runInternal(IAction action, boolean isShift) {
        this.run(action);
    }

    private ILaunchConfiguration resolveContextConfiguration() {
        List<ILaunchConfiguration> configs;
        SelectedResourceManager srm = SelectedResourceManager.getDefault();
        IStructuredSelection selection = srm.getCurrentSelection();
        List<LaunchShortcutExtension> shortcuts = null;
        IResource resource = srm.getSelectedResource();
        LaunchingResourceManager lrm = DebugUIPlugin.getDefault().getLaunchingResourceManager();
        shortcuts = lrm.getShortcutsForSelection(selection, this.getMode());
        if (resource == null) {
            resource = lrm.getLaunchableResource(shortcuts, selection);
        }
        if ((configs = lrm.getParticipatingLaunchConfigurations(selection, resource, shortcuts, this.getMode())).size() == 1) {
            return configs.get(0);
        }
        if (configs.size() > 1) {
            ILaunchConfiguration config = this.getLaunchConfigurationManager().getMRUConfiguration(configs, this.fLaunchGroup, resource);
            if (config != null) {
                return config;
            }
            LaunchConfigurationSelectionDialog dialog = new LaunchConfigurationSelectionDialog(DebugUIPlugin.getShell(), configs);
            if (dialog.open() == 0) {
                return (ILaunchConfiguration)dialog.getResult()[0];
            }
            return null;
        }
        if (shortcuts.size() > 1) {
            LaunchShortcutSelectionDialog dialog = new LaunchShortcutSelectionDialog(shortcuts, resource, this.getMode());
            if (dialog.open() == 0) {
                LaunchShortcutExtension ext = (LaunchShortcutExtension)dialog.getResult()[0];
                return this.createConfigurationFromTypes(ext.getAssociatedConfigurationTypes());
            }
            return null;
        }
        if (shortcuts.size() == 1) {
            LaunchShortcutExtension ext = shortcuts.get(0);
            return this.createConfigurationFromTypes(ext.getAssociatedConfigurationTypes());
        }
        return this.getLaunchConfigurationManager().getFilteredLastLaunch(this.getLaunchGroupIdentifier());
    }

    private ILaunchConfiguration createConfigurationFromTypes(Set<String> types) {
        if (types != null && types.size() > 0) {
            try {
                ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType((String)types.toArray()[0]);
                ILaunchConfigurationWorkingCopy copy = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(LaunchConfigurationsMessages.CreateLaunchConfigurationAction_New_configuration_2));
                return copy;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void init(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction == null) {
            this.initialize(action);
        }
    }

    public void init(IWorkbenchWindow window) {
        if (this instanceof AbstractLaunchToolbarAction) {
            DebugUIPlugin.getDefault().getLaunchingResourceManager().addLaunchLabelUpdateListener(this.fLabelListener);
        }
    }

    @Deprecated
    protected LaunchHistory getLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory(this.getLaunchGroupIdentifier());
    }

    private LaunchHistory internalGetHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory(this.getLaunchGroupIdentifier());
    }

    protected ILaunchConfiguration[] getHistory() {
        return LaunchConfigurationManager.filterConfigs(this.internalGetHistory().getHistory());
    }

    protected ILaunchConfiguration[] getFavorites() {
        return LaunchConfigurationManager.filterConfigs(this.internalGetHistory().getFavorites());
    }

    protected String getMode() {
        return this.internalGetHistory().getLaunchGroup().getMode();
    }

    private LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    protected String getLaunchGroupIdentifier() {
        return this.fLaunchGroup.getIdentifier();
    }
}

