/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.ElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.ElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStateUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

class ViewerStateTracker {
    static final int STATE_SAVE_SEQUENCE_BEGINS = 4;
    static final int STATE_SAVE_SEQUENCE_COMPLETE = 5;
    static final int STATE_RESTORE_SEQUENCE_BEGINS = 6;
    static final int STATE_RESTORE_SEQUENCE_COMPLETE = 7;
    private TreeModelContentProvider fContentProvider;
    private Map<String, ModelDelta> fViewerStates = new LRUMap<String, ModelDelta>(20);
    private ModelDelta fPendingState = null;
    private boolean fInStateRestore = false;
    private ListenerList<IStateUpdateListener> fStateUpdateListeners = new ListenerList();
    protected PendingRevealDelta fPendingSetTopItem = null;
    private Set<IElementMementoCollector> fPendingStateSaves = new HashSet<IElementMementoCollector>();
    private Object fQueuedRestore = null;
    private Map<CompareRequestKey, ElementCompareRequest> fCompareRequestsInProgress = new LinkedHashMap<CompareRequestKey, ElementCompareRequest>();

    ViewerStateTracker(TreeModelContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    void dispose() {
        Assert.isTrue((this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        for (IElementMementoCollector emc : this.fPendingStateSaves) {
            emc.cancel();
        }
        this.fStateUpdateListeners.clear();
        for (ElementCompareRequest ecr : this.fCompareRequestsInProgress.values()) {
            ecr.cancel();
        }
        this.fCompareRequestsInProgress.clear();
        if (this.fPendingSetTopItem != null) {
            this.fPendingSetTopItem.dispose();
        }
    }

    private void startRestoreViewerState(final Object input) {
        Assert.isTrue((this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fPendingState = null;
        final IElementMementoProvider defaultProvider = ViewerAdapterService.getMementoProvider(input);
        if (defaultProvider != null) {
            final ModelDelta delta = new ModelDelta(input, 0);
            XMLMemento inputMemento = XMLMemento.createWriteRoot((String)"VIEWER_INPUT_MEMENTO");
            IElementMementoCollector manager = new IElementMementoCollector(){
                private IElementMementoRequest fRequest;

                @Override
                public void requestComplete(ElementMementoRequest request) {
                    if (ViewerStateTracker.this.fContentProvider.isDisposed()) {
                        return;
                    }
                    ViewerStateTracker.this.notifyStateUpdate(input, 3, request);
                    if (!request.isCanceled() && (request.getStatus() == null || request.getStatus().isOK())) {
                        XMLMemento keyMemento = (XMLMemento)delta.getElement();
                        StringWriter writer = new StringWriter();
                        try {
                            keyMemento.save((Writer)writer);
                            String keyMementoString = writer.toString();
                            ModelDelta stateDelta = (ModelDelta)ViewerStateTracker.this.fViewerStates.get(keyMementoString);
                            if (stateDelta != null) {
                                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                                    DebugUIPlugin.trace("STATE RESTORE INPUT COMARE ENDED : " + this.fRequest + " - MATCHING STATE FOUND");
                                }
                                ViewerStateTracker.this.fContentProvider.getViewer().getDisplay().asyncExec(() -> {
                                    if (!ViewerStateTracker.this.fContentProvider.isDisposed() && input.equals(ViewerStateTracker.this.fContentProvider.getViewer().getInput())) {
                                        ModelDelta stateDelta2 = (ModelDelta)ViewerStateTracker.this.fViewerStates.remove(keyMementoString);
                                        if (stateDelta2 != null) {
                                            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                                                DebugUIPlugin.trace("STATE RESTORE BEGINS");
                                                DebugUIPlugin.trace("\tRESTORE: " + stateDelta2);
                                                ViewerStateTracker.this.notifyStateUpdate(input, 6, null);
                                            }
                                            stateDelta2.setElement(input);
                                            ViewerStateTracker.this.fPendingState = stateDelta2;
                                            ViewerStateTracker.this.doInitialRestore(ViewerStateTracker.this.fPendingState);
                                        }
                                    } else if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                                        DebugUIPlugin.trace("STATE RESTORE CANCELED.");
                                    }
                                });
                            } else if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                                DebugUIPlugin.trace("STATE RESTORE INPUT COMARE ENDED : " + this.fRequest + " - NO MATCHING STATE");
                            }
                        }
                        catch (IOException e) {
                            DebugUIPlugin.log(e);
                        }
                    } else {
                        ViewerStateTracker.this.notifyStateUpdate(input, 6, null);
                    }
                }

                @Override
                public void processReqeusts() {
                    ViewerStateTracker.this.notifyStateUpdate(input, 6, null);
                    if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                        DebugUIPlugin.trace("STATE RESTORE INPUT COMARE BEGIN : " + this.fRequest);
                    }
                    ViewerStateTracker.this.notifyStateUpdate(input, 2, this.fRequest);
                    defaultProvider.encodeElements(new IElementMementoRequest[]{this.fRequest});
                }

                @Override
                public void addRequest(ElementMementoRequest req) {
                    this.fRequest = req;
                }

                @Override
                public void cancel() {
                }
            };
            manager.addRequest(new ElementMementoRequest(this.fContentProvider, this.fContentProvider.getViewer().getInput(), manager, delta.getElement(), this.fContentProvider.getViewerTreePath(delta), (IMemento)inputMemento, delta));
            manager.processReqeusts();
        } else if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
            DebugUIPlugin.trace("STATE RESTORE: No input memento provider");
        }
    }

    void appendToPendingStateDelta(TreePath path) {
        ModelDelta appendDeltaRoot;
        if (this.fContentProvider.getViewer() == null) {
            return;
        }
        if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
            DebugUIPlugin.trace("STATE APPEND BEGIN: " + path.getLastSegment());
        }
        ModelDelta delta = appendDeltaRoot = new ModelDelta(this.fContentProvider.getViewer().getInput(), 0);
        int i = 0;
        while (i < path.getSegmentCount()) {
            delta = delta.addNode(path.getSegment(i), 0);
            ++i;
        }
        if (!this.fContentProvider.getViewer().saveElementState(path, delta, 0x2300000)) {
            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                DebugUIPlugin.trace("STATE APPEND CANCEL: Element " + path.getLastSegment() + " not found.");
            }
            return;
        }
        delta.accept((d, depth) -> {
            if ((d.getFlags() & 0x100000) != 0) {
                ((ModelDelta)d).setFlags(d.getFlags() | 0x400);
            }
            return true;
        });
        if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
            DebugUIPlugin.trace("\tAPPEND DELTA: " + appendDeltaRoot);
        }
        if (this.fPendingState != null) {
            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                DebugUIPlugin.trace("\tAPPEND OUTSTANDING RESTORE: " + this.fPendingState);
            }
            if (path.getSegmentCount() > 0) {
                this.fPendingState.accept((pendingDeltaNode, depth) -> {
                    TreePath pendingDeltaPath = this.fContentProvider.getViewerTreePath(pendingDeltaNode);
                    if (path.startsWith(pendingDeltaPath, null)) {
                        ModelDelta appendDelta = this.findDeltaForPath(appendDeltaRoot, pendingDeltaPath);
                        appendDelta.setFlags(pendingDeltaNode.getFlags());
                        appendDelta.setChildCount(pendingDeltaNode.getChildCount());
                        appendDelta.setIndex(pendingDeltaNode.getIndex());
                        return true;
                    }
                    return false;
                });
            }
            this.fPendingState.accept((pendingDeltaNode, depth) -> {
                if (pendingDeltaNode.getParentDelta() == null) {
                    return true;
                }
                ModelDelta saveDeltaNode = this.findSubDeltaParent(appendDeltaRoot, pendingDeltaNode);
                if (saveDeltaNode != null && !this.isDeltaInParent(pendingDeltaNode, saveDeltaNode) && pendingDeltaNode.getFlags() != 0) {
                    saveDeltaNode.setChildCount(pendingDeltaNode.getParentDelta().getChildCount());
                    this.copyIntoDelta(pendingDeltaNode, saveDeltaNode);
                } else if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("\tSKIPPED: " + pendingDeltaNode.getElement());
                }
                if (pendingDeltaNode.getElement() instanceof IMemento) {
                    return false;
                }
                return pendingDeltaNode.getChildCount() > 0;
            });
        }
        if (appendDeltaRoot.getChildDeltas().length > 0) {
            if (this.fPendingState == null) {
                this.notifyStateUpdate(appendDeltaRoot.getElement(), 6, null);
            }
            this.fPendingState = appendDeltaRoot;
            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                DebugUIPlugin.trace("STATE APPEND COMPLETE " + this.fPendingState);
            }
        } else if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
            DebugUIPlugin.trace("STATE APPEND CANCELED: No Data");
        }
    }

    protected void saveViewerState(Object input) {
        Iterator<ElementCompareRequest> itr = this.fCompareRequestsInProgress.values().iterator();
        while (itr.hasNext()) {
            itr.next().cancel();
            itr.remove();
        }
        IElementMementoProvider stateProvider = ViewerAdapterService.getMementoProvider(input);
        if (stateProvider != null) {
            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                DebugUIPlugin.trace("STATE SAVE BEGIN: " + input);
            }
            ModelDelta saveDeltaRoot = new ModelDelta(input, 0);
            this.buildViewerState(saveDeltaRoot);
            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                DebugUIPlugin.trace("\tSAVE DELTA FROM VIEW:\n" + saveDeltaRoot);
            }
            if (this.fPendingSetTopItem != null) {
                ModelDelta revealDelta = this.fPendingSetTopItem.getDelta();
                revealDelta.setFlags(revealDelta.getFlags() | 0x1000000);
                this.fPendingSetTopItem.dispose();
                ModelDelta saveDeltaNode = this.findSubDeltaParent(saveDeltaRoot, revealDelta);
                if (saveDeltaNode != null) {
                    this.clearRevealFlag(saveDeltaRoot);
                    ModelDelta child = saveDeltaNode.getChildDelta(revealDelta.getElement(), revealDelta.getIndex());
                    if (child != null) {
                        child.setFlags(child.getFlags() | 0x1000000);
                    } else {
                        saveDeltaNode.setChildCount(revealDelta.getParentDelta().getChildCount());
                        this.copyIntoDelta(revealDelta, saveDeltaNode);
                    }
                } else if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("\tSKIPPED: " + revealDelta.getElement());
                }
            }
            if (this.fPendingState != null) {
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("\tSAVE OUTSTANDING RESTORE: " + this.fPendingState);
                }
                IModelDeltaVisitor pendingStateVisitor = (pendingDeltaNode, depth) -> {
                    if (pendingDeltaNode.getParentDelta() == null) {
                        return true;
                    }
                    ModelDelta saveDeltaNode = this.findSubDeltaParent(saveDeltaRoot, pendingDeltaNode);
                    if (saveDeltaNode != null && !this.isDeltaInParent(pendingDeltaNode, saveDeltaNode) && pendingDeltaNode.getFlags() != 0) {
                        if ((pendingDeltaNode.getFlags() & 0x1000000) != 0) {
                            this.clearRevealFlag(saveDeltaRoot);
                        }
                        saveDeltaNode.setChildCount(pendingDeltaNode.getParentDelta().getChildCount());
                        this.copyIntoDelta(pendingDeltaNode, saveDeltaNode);
                    } else if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                        DebugUIPlugin.trace("\tSKIPPED: " + pendingDeltaNode.getElement());
                    }
                    if (pendingDeltaNode.getElement() instanceof IMemento) {
                        return false;
                    }
                    return pendingDeltaNode.getChildCount() > 0;
                };
                this.fPendingState.accept(pendingStateVisitor);
            }
            if (saveDeltaRoot.getChildDeltas().length > 0) {
                this.encodeDelta(saveDeltaRoot, stateProvider);
            } else if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                DebugUIPlugin.trace("STATE SAVE CANCELED, NO DATA");
            }
        }
    }

    private void clearRevealFlag(ModelDelta saveRootDelta) {
        IModelDeltaVisitor clearDeltaVisitor = (delta, depth) -> {
            if ((delta.getFlags() & 0x1000000) != 0) {
                ((ModelDelta)delta).setFlags(delta.getFlags() & 0xFEFFFFFF);
            }
            return true;
        };
        saveRootDelta.accept(clearDeltaVisitor);
    }

    private ModelDelta findSubDeltaParent(ModelDelta destinationDeltaRoot, IModelDelta subDelta) {
        LinkedList<IModelDelta> deltaPath = new LinkedList<IModelDelta>();
        IModelDelta delta = subDelta;
        while (delta.getParentDelta() != null) {
            delta = delta.getParentDelta();
            deltaPath.addFirst(delta);
        }
        Iterator itr = deltaPath.iterator();
        itr.next();
        ModelDelta saveDelta = destinationDeltaRoot;
        while (saveDelta != null && itr.hasNext()) {
            IModelDelta itrDelta = (IModelDelta)itr.next();
            saveDelta = saveDelta.getChildDelta(itrDelta.getElement(), itrDelta.getIndex());
        }
        return saveDelta;
    }

    private ModelDelta findDeltaForPath(ModelDelta root, TreePath path) {
        ModelDelta delta = root;
        int i = 0;
        while (i < path.getSegmentCount()) {
            if ((delta = delta.getChildDelta(path.getSegment(i))) == null) {
                return null;
            }
            ++i;
        }
        return delta;
    }

    private boolean isDeltaInParent(IModelDelta delta, ModelDelta destParent) {
        return destParent.getChildDelta(delta.getElement(), delta.getIndex()) != null;
    }

    private void copyIntoDelta(IModelDelta delta, ModelDelta destParent) {
        ModelDelta newDelta = destParent.addNode(delta.getElement(), delta.getIndex(), delta.getFlags(), delta.getChildCount());
        int i = 0;
        while (i < delta.getChildDeltas().length) {
            this.copyIntoDelta(delta.getChildDeltas()[i], newDelta);
            ++i;
        }
    }

    protected void encodeDelta(final ModelDelta rootDelta, final IElementMementoProvider defaultProvider) {
        final Object input = rootDelta.getElement();
        XMLMemento inputMemento = XMLMemento.createWriteRoot((String)"VIEWER_INPUT_MEMENTO");
        XMLMemento childrenMemento = XMLMemento.createWriteRoot((String)"CHILDREN_MEMENTO");
        IElementMementoCollector manager = new IElementMementoCollector(){
            private List<IElementMementoRequest> fRequests = new ArrayList<IElementMementoRequest>();
            private boolean fCanceled = false;

            @Override
            public void requestComplete(ElementMementoRequest request) {
                Assert.isTrue((ViewerStateTracker.this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
                ViewerStateTracker.this.notifyStateUpdate(input, 3, request);
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("\tSTATE END: " + request);
                }
                if (!request.isCanceled() && (request.getStatus() == null || request.getStatus().isOK())) {
                    boolean requestsComplted = false;
                    if (!this.fCanceled) {
                        this.fRequests.remove(request);
                        requestsComplted = this.fRequests.isEmpty();
                    }
                    if (requestsComplted) {
                        XMLMemento keyMemento = (XMLMemento)rootDelta.getElement();
                        StringWriter writer = new StringWriter();
                        try {
                            keyMemento.save((Writer)writer);
                            ViewerStateTracker.this.fViewerStates.put(writer.toString(), rootDelta);
                        }
                        catch (IOException e) {
                            DebugUIPlugin.log(e);
                        }
                        if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                            DebugUIPlugin.trace("STATE SAVE COMPLETED: " + rootDelta);
                        }
                        ViewerStateTracker.this.stateSaveComplete(input, this);
                    }
                } else {
                    this.cancel();
                }
            }

            @Override
            public void cancel() {
                Assert.isTrue((ViewerStateTracker.this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
                if (this.fCanceled) {
                    return;
                }
                this.fCanceled = true;
                for (IElementMementoRequest req : this.fRequests) {
                    req.cancel();
                }
                this.fRequests.clear();
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("STATE SAVE ABORTED: " + rootDelta.getElement());
                }
                ViewerStateTracker.this.stateSaveComplete(input, this);
            }

            @Override
            public void processReqeusts() {
                ArrayList<IElementMementoRequest> reqs;
                IElementMementoProvider provider;
                Assert.isTrue((ViewerStateTracker.this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
                HashMap<IElementMementoProvider, ArrayList<IElementMementoRequest>> providers = new HashMap<IElementMementoProvider, ArrayList<IElementMementoRequest>>();
                for (IElementMementoRequest iElementMementoRequest : this.fRequests) {
                    ViewerStateTracker.this.notifyStateUpdate(input, 2, iElementMementoRequest);
                    provider = ViewerAdapterService.getMementoProvider(iElementMementoRequest.getElement());
                    if (provider == null) {
                        provider = defaultProvider;
                    }
                    if ((reqs = (List)providers.get(provider)) == null) {
                        reqs = new ArrayList<IElementMementoRequest>();
                        providers.put(provider, reqs);
                    }
                    reqs.add(iElementMementoRequest);
                }
                for (Map.Entry entry : providers.entrySet()) {
                    provider = (IElementMementoProvider)entry.getKey();
                    reqs = (ArrayList<IElementMementoRequest>)entry.getValue();
                    provider.encodeElements(reqs.toArray(new IElementMementoRequest[reqs.size()]));
                }
            }

            @Override
            public void addRequest(ElementMementoRequest request) {
                Assert.isTrue((ViewerStateTracker.this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
                this.fRequests.add(request);
            }
        };
        IModelDeltaVisitor visitor = (delta, depth) -> {
            if ((delta.getFlags() | 0x100000) != 0) {
                ((ModelDelta)delta).setFlags(delta.getFlags() | 0x400);
            }
            if (delta.getParentDelta() == null) {
                manager.addRequest(new ElementMementoRequest(this.fContentProvider, input, manager, delta.getElement(), this.fContentProvider.getViewerTreePath(delta), (IMemento)inputMemento, (ModelDelta)delta));
            } else if (!(delta.getElement() instanceof XMLMemento)) {
                manager.addRequest(new ElementMementoRequest(this.fContentProvider, input, manager, delta.getElement(), this.fContentProvider.getViewerTreePath(delta), childrenMemento.createChild("CHILD_ELEMENT"), (ModelDelta)delta));
            }
            return true;
        };
        rootDelta.accept(visitor);
        this.stateSaveStarted(input, manager);
        manager.processReqeusts();
    }

    private void stateSaveStarted(Object input, IElementMementoCollector manager) {
        Assert.isTrue((this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.notifyStateUpdate(input, 4, null);
        this.fPendingStateSaves.add(manager);
    }

    private void stateSaveComplete(Object input, IElementMementoCollector manager) {
        Assert.isTrue((this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.notifyStateUpdate(input, 5, null);
        this.fPendingStateSaves.remove(manager);
        if (this.fQueuedRestore != null) {
            Object temp = this.fQueuedRestore;
            this.fQueuedRestore = null;
            this.restoreViewerState(temp);
        }
    }

    private boolean isSavingState() {
        Assert.isTrue((this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        return !this.fPendingStateSaves.isEmpty();
    }

    protected void restoreViewerState(Object input) {
        Assert.isTrue((this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fPendingState = null;
        if (this.isSavingState()) {
            this.fQueuedRestore = input;
        } else {
            this.startRestoreViewerState(input);
        }
    }

    public void cancelRestore(TreePath path, int flags) {
        int mask;
        if (this.fInStateRestore) {
            return;
        }
        if ((flags & 0x1000000) != 0 && this.fPendingSetTopItem != null) {
            this.fPendingSetTopItem.dispose();
            return;
        }
        if (this.fPendingState == null) {
            return;
        }
        if ((flags & 0x1200000) != 0) {
            mask = flags & 0x1200000;
            this.fPendingState.accept((delta, depth) -> {
                int deltaFlags = delta.getFlags();
                int newFlags = deltaFlags & ~mask;
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext()) && deltaFlags != newFlags) {
                    DebugUIPlugin.trace("\tCANCEL: " + delta.getElement() + "(" + Integer.toHexString(deltaFlags & mask) + ")");
                }
                ((ModelDelta)delta).setFlags(newFlags);
                return true;
            });
        }
        if ((flags & 0xFEDFFFFF) != 0) {
            mask = flags & 0xFEDFFFFF;
            this.fPendingState.accept((delta, depth) -> {
                if (depth < path.getSegmentCount()) {
                    TreePath deltaPath1 = this.fContentProvider.getViewerTreePath(delta);
                    return path.startsWith(deltaPath1, null);
                }
                if (depth == path.getSegmentCount()) {
                    TreePath deltaPath2 = this.fContentProvider.getViewerTreePath(delta);
                    if (deltaPath2.equals((Object)path)) {
                        int deltaFlags = delta.getFlags();
                        int newFlags = deltaFlags & ~mask;
                        if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext()) && deltaFlags != newFlags) {
                            DebugUIPlugin.trace("\tCANCEL: " + delta.getElement() + "(" + Integer.toHexString(deltaFlags & mask) + ")");
                        }
                        ((ModelDelta)delta).setFlags(newFlags);
                        if ((flags & 0x100000) != 0) {
                            return true;
                        }
                    }
                    return false;
                }
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext()) && delta.getFlags() != 0) {
                    DebugUIPlugin.trace("\tCANCEL: " + delta.getElement() + "(" + Integer.toHexString(delta.getFlags()) + ")");
                }
                ((ModelDelta)delta).setFlags(0);
                return true;
            });
        }
    }

    void restorePendingStateOnUpdate(TreePath path, int modelIndex, boolean knowsHasChildren, boolean knowsChildCount, boolean checkChildrenRealized) {
        Assert.isTrue((this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        if (this.fPendingState == null) {
            return;
        }
        IModelDeltaVisitor visitor = (delta, depth) -> {
            Object potentialMatch;
            Object element = delta.getElement();
            Object object = potentialMatch = depth != 0 ? path.getSegment(depth - 1) : this.fContentProvider.getViewer().getInput();
            if (depth == path.getSegmentCount()) {
                if (element instanceof IMemento) {
                    IElementMementoProvider provider = ViewerAdapterService.getMementoProvider(potentialMatch);
                    if (provider == null) {
                        provider = ViewerAdapterService.getMementoProvider(this.fContentProvider.getViewer().getInput());
                    }
                    if (provider != null) {
                        CompareRequestKey key = new CompareRequestKey(path, delta);
                        ElementCompareRequest existingRequest = this.fCompareRequestsInProgress.get(key);
                        if (existingRequest != null) {
                            existingRequest.setKnowsHasChildren(knowsHasChildren);
                            existingRequest.setKnowsChildCount(knowsChildCount);
                            existingRequest.setCheckChildrenRealized(checkChildrenRealized);
                        } else {
                            ElementCompareRequest compareRequest = new ElementCompareRequest(this.fContentProvider, this.fContentProvider.getViewer().getInput(), potentialMatch, path, (IMemento)element, (ModelDelta)delta, modelIndex, knowsHasChildren, knowsChildCount, checkChildrenRealized);
                            this.fCompareRequestsInProgress.put(key, compareRequest);
                            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                                DebugUIPlugin.trace("\tSTATE BEGIN: " + compareRequest);
                            }
                            this.notifyStateUpdate(element, 2, compareRequest);
                            provider.compareElements(new IElementCompareRequest[]{compareRequest});
                        }
                    }
                } else if (element.equals(potentialMatch)) {
                    this.restorePendingStateNode((ModelDelta)delta, knowsHasChildren, knowsChildCount, checkChildrenRealized);
                }
                return false;
            }
            return element.equals(potentialMatch);
        };
        try {
            this.fInStateRestore = true;
            this.fPendingState.accept(visitor);
        }
        finally {
            this.fInStateRestore = false;
        }
        this.checkIfRestoreComplete();
    }

    void checkIfRestoreComplete() {
        Assert.isTrue((this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        if (this.fPendingState == null) {
            return;
        }
        class CheckState
        implements IModelDeltaVisitor {
            private boolean complete = true;

            CheckState() {
            }

            @Override
            public boolean visit(IModelDelta delta, int depth) {
                int flags = delta.getFlags() & 0xFFFFFBFF;
                if (flags != 0) {
                    IModelDelta parentDelta = delta.getParentDelta();
                    if (parentDelta != null && parentDelta.getFlags() == 0) {
                        TreePath deltaPath = ViewerStateTracker.this.fContentProvider.getViewerTreePath(delta);
                        if (!(ViewerStateTracker.this.fContentProvider.areElementUpdatesPending(deltaPath) || delta.getElement() instanceof IMemento && this.areMementoUpdatesPending(delta))) {
                            return false;
                        }
                    }
                    if (flags != 0x1000000 || delta.getElement() instanceof IMemento) {
                        this.complete = false;
                        return false;
                    }
                }
                return true;
            }

            public boolean isComplete() {
                return this.complete;
            }

            private boolean areMementoUpdatesPending(IModelDelta delta) {
                for (CompareRequestKey key : ViewerStateTracker.this.fCompareRequestsInProgress.keySet()) {
                    if (!delta.getElement().equals(key.fDelta.getElement())) continue;
                    return true;
                }
                return false;
            }
        }
        CheckState state = new CheckState();
        this.fPendingState.accept(state);
        if (state.isComplete()) {
            if (this.fPendingSetTopItem == null) {
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("STATE RESTORE COMPELTE: " + this.fPendingState);
                }
                this.notifyStateUpdate(this.fPendingState.getElement(), 7, null);
            }
            this.fPendingState = null;
        }
    }

    void restorePendingStateNode(ModelDelta delta, boolean knowsHasChildren, boolean knowsChildCount, boolean checkChildrenRealized) {
        int childCount;
        int modelIndex;
        int i;
        IModelDelta[] childDeltas;
        TreePath treePath = this.fContentProvider.getViewerTreePath(delta);
        IInternalTreeModelViewer viewer = this.fContentProvider.getViewer();
        if (knowsHasChildren) {
            if ((delta.getFlags() & 0x100000) != 0) {
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("\tRESTORE EXPAND: " + treePath.getLastSegment());
                }
                viewer.expandToLevel(treePath, 1);
                delta.setFlags(delta.getFlags() & 0xFFEFFFFF);
            }
            if ((delta.getFlags() & 0x2000000) != 0) {
                int autoexpand;
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("\tRESTORE COLLAPSE: " + treePath.getLastSegment());
                }
                if ((autoexpand = this.fContentProvider.getViewer().getAutoExpandLevel()) != -1 && autoexpand < treePath.getSegmentCount() + 1) {
                    this.fContentProvider.getViewer().setExpandedState(treePath, false);
                }
                delta.setFlags(delta.getFlags() & 0xFDFFFFFF);
            }
        }
        if ((delta.getFlags() & 0x200000) != 0) {
            ITreeSelection currentSelection;
            delta.setFlags(delta.getFlags() & 0xFFDFFFFF);
            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                DebugUIPlugin.trace("\tRESTORE SELECT: " + treePath.getLastSegment());
            }
            if ((currentSelection = (ITreeSelection)viewer.getSelection()) == null || currentSelection.isEmpty()) {
                viewer.setSelection((ISelection)new TreeSelection(treePath), false, false);
            } else {
                TreePath[] currentPaths = currentSelection.getPaths();
                boolean pathInSelection = false;
                int i2 = 0;
                while (i2 < currentPaths.length) {
                    if (currentPaths[i2].equals((Object)treePath)) {
                        pathInSelection = true;
                        break;
                    }
                    ++i2;
                }
                if (!pathInSelection) {
                    TreePath[] newPaths = new TreePath[currentPaths.length + 1];
                    System.arraycopy(currentPaths, 0, newPaths, 0, currentPaths.length);
                    newPaths[newPaths.length - 1] = treePath;
                    viewer.setSelection((ISelection)new TreeSelection(newPaths), false, false);
                }
            }
        }
        if ((delta.getFlags() & 0x1000000) != 0) {
            delta.setFlags(delta.getFlags() & 0xFEFFFFFF);
            boolean setTopItem = true;
            childDeltas = delta.getChildDeltas();
            i = 0;
            while (i < childDeltas.length) {
                IModelDelta childDelta = childDeltas[i];
                modelIndex = childDelta.getIndex();
                if (modelIndex >= 0 && (childDelta.getFlags() & 0x1000000) != 0) {
                    setTopItem = false;
                }
                ++i;
            }
            if (setTopItem) {
                Assert.isTrue((this.fPendingSetTopItem == null ? 1 : 0) != 0);
                this.fPendingSetTopItem = new PendingRevealDelta(treePath, delta);
                viewer.addViewerUpdateListener(this.fPendingSetTopItem);
            }
        }
        if (knowsChildCount && (childCount = viewer.getChildCount(treePath)) >= 0) {
            childDeltas = (ModelDelta[])delta.getChildDeltas();
            i = 0;
            while (i < childDeltas.length) {
                IModelDelta childDelta = childDeltas[i];
                modelIndex = ((ModelDelta)childDelta).getIndex();
                if (modelIndex >= 0 && (((ModelDelta)childDelta).getFlags() & 0x1000000) != 0) {
                    if (modelIndex < childCount) {
                        this.fContentProvider.doUpdateElement(treePath, modelIndex);
                    } else {
                        ((ModelDelta)childDelta).setFlags(((ModelDelta)childDelta).getFlags() & 0xFEFFFFFF);
                    }
                }
                ++i;
            }
        }
        if (checkChildrenRealized && !this.fContentProvider.areChildrenUpdatesPending(treePath) && this.fContentProvider.getViewer().getElementChildrenRealized(treePath) || knowsHasChildren && !viewer.getHasChildren(treePath)) {
            if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
                DebugUIPlugin.trace("\tRESTORE CONTENT: " + treePath.getLastSegment());
            }
            delta.setFlags(delta.getFlags() & 0xFFFFFBFF);
        }
    }

    protected void doInitialRestore(ModelDelta delta) {
        this.markRevealDelta(delta);
        int count = this.fContentProvider.getViewer().getChildCount(TreePath.EMPTY);
        int i = 0;
        while (i < count) {
            Object data = this.fContentProvider.getViewer().getChildElement(TreePath.EMPTY, i);
            if (data != null) {
                this.restorePendingStateOnUpdate(new TreePath(new Object[]{data}), i, false, false, false);
            }
            ++i;
        }
    }

    private ModelDelta markRevealDelta(ModelDelta rootDelta) {
        ModelDelta[] revealDelta = new ModelDelta[1];
        IModelDeltaVisitor visitor = (delta, depth) -> {
            if ((delta.getFlags() & 0x1000000) != 0) {
                modelDeltaArray[0] = (ModelDelta)delta;
            }
            return revealDelta[0] == null;
        };
        rootDelta.accept(visitor);
        if (revealDelta[0] != null) {
            ModelDelta parentDelta = (ModelDelta)revealDelta[0].getParentDelta();
            while (parentDelta.getParentDelta() != null) {
                revealDelta[0] = parentDelta;
                revealDelta[0].setFlags(revealDelta[0].getFlags() | 0x1000000);
                parentDelta = (ModelDelta)parentDelta.getParentDelta();
            }
        }
        return revealDelta[0];
    }

    private void buildViewerState(ModelDelta delta) {
        IInternalTreeModelViewer viewer = this.fContentProvider.getViewer();
        viewer.saveElementState(TreeModelContentProvider.EMPTY_TREE_PATH, delta, 0x300000);
        TreePath topElementPath = viewer.getTopElementPath();
        if (topElementPath != null) {
            ModelDelta parentDelta = delta;
            TreePath parentPath = TreeModelContentProvider.EMPTY_TREE_PATH;
            int i = 0;
            while (i < topElementPath.getSegmentCount()) {
                Object element = topElementPath.getSegment(i);
                int index = viewer.findElementIndex(parentPath, element);
                ModelDelta childDelta = parentDelta.getChildDelta(element);
                parentDelta = childDelta == null ? parentDelta.addNode(element, index, 0) : childDelta;
                parentPath = parentPath.createChildPath(element);
                ++i;
            }
            parentDelta.setFlags(parentDelta.getFlags() | 0x1000000);
        }
    }

    void cancelStateSubtreeUpdates(TreePath path) {
        Iterator<CompareRequestKey> itr = this.fCompareRequestsInProgress.keySet().iterator();
        while (itr.hasNext()) {
            CompareRequestKey key = itr.next();
            if (!key.fPath.startsWith(path, null)) continue;
            ElementCompareRequest compareRequest = this.fCompareRequestsInProgress.get(key);
            compareRequest.cancel();
            itr.remove();
        }
    }

    void compareFinished(ElementCompareRequest request, ModelDelta delta) {
        this.notifyStateUpdate(request.getViewerInput(), 3, request);
        if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.fContentProvider.getPresentationContext())) {
            DebugUIPlugin.trace("\tSTATE END: " + request + " = " + false);
        }
        this.fCompareRequestsInProgress.remove(new CompareRequestKey(request.getElementPath(), delta));
        if (!request.isCanceled()) {
            if (request.isEqual()) {
                delta.setElement(request.getElement());
                this.restorePendingStateNode(delta, request.knowsHasChildren(), request.knowChildCount(), request.checkChildrenRealized());
            } else if (request.getModelIndex() != -1 && (delta.getFlags() & 0x1000000) != 0 && delta.getIndex() == request.getModelIndex()) {
                delta.setFlags(delta.getFlags() & 0xFEFFFFFF);
            }
        }
        this.checkIfRestoreComplete();
    }

    void addStateUpdateListener(IStateUpdateListener listener) {
        this.fStateUpdateListeners.add((Object)listener);
    }

    void removeStateUpdateListener(IStateUpdateListener listener) {
        this.fStateUpdateListeners.remove((Object)listener);
    }

    void notifyStateUpdate(final Object input, final int type, final IViewerUpdate update) {
        if (!this.fStateUpdateListeners.isEmpty()) {
            Iterator iterator = this.fStateUpdateListeners.iterator();
            while (iterator.hasNext()) {
                IStateUpdateListener iStateUpdateListener;
                final IStateUpdateListener listener = iStateUpdateListener = (IStateUpdateListener)iterator.next();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 4: {
                                listener.stateSaveUpdatesBegin(input);
                                break;
                            }
                            case 5: {
                                listener.stateSaveUpdatesComplete(input);
                                break;
                            }
                            case 6: {
                                listener.stateRestoreUpdatesBegin(input);
                                break;
                            }
                            case 7: {
                                listener.stateRestoreUpdatesComplete(input);
                                break;
                            }
                            case 2: {
                                listener.stateUpdateStarted(input, update);
                                break;
                            }
                            case 3: {
                                listener.stateUpdateComplete(input, update);
                                break;
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
            }
        }
    }

    private static class CompareRequestKey {
        TreePath fPath;
        IModelDelta fDelta;

        CompareRequestKey(TreePath path, IModelDelta delta) {
            this.fPath = path;
            this.fDelta = delta;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompareRequestKey) {
                CompareRequestKey key = (CompareRequestKey)obj;
                return key.fDelta.equals(this.fDelta) && key.fPath.equals((Object)this.fPath);
            }
            return false;
        }

        public int hashCode() {
            return this.fDelta.hashCode() + this.fPath.hashCode();
        }
    }

    static interface IElementMementoCollector {
        public void addRequest(ElementMementoRequest var1);

        public void requestComplete(ElementMementoRequest var1);

        public void processReqeusts();

        public void cancel();
    }

    class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int fMaxSize;

        LRUMap(int maxSize) {
            this.fMaxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.fMaxSize;
        }
    }

    private class PendingRevealDelta
    implements IViewerUpdateListener {
        private final TreePath fPathToReveal;
        private final ModelDelta fRevealDelta;
        private int fCounter = 0;
        private Object fModelInput;

        PendingRevealDelta(TreePath pathToReveal, ModelDelta revealDelta) {
            this.fModelInput = ViewerStateTracker.this.fPendingState.getElement();
            this.fPathToReveal = pathToReveal;
            this.fRevealDelta = revealDelta;
        }

        @Override
        public void viewerUpdatesComplete() {
            TreePath parentPath;
            int index;
            Assert.isTrue((ViewerStateTracker.this.fContentProvider.getViewer().getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
            IInternalTreeModelViewer viewer = ViewerStateTracker.this.fContentProvider.getViewer();
            if (viewer == null || ViewerStateTracker.this.fPendingSetTopItem != this) {
                return;
            }
            TreePath topPath = viewer.getTopElementPath();
            if (!this.fPathToReveal.equals((Object)topPath) && (index = viewer.findElementIndex(parentPath = this.fPathToReveal.getParentPath(), this.fPathToReveal.getLastSegment())) >= 0) {
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("\tRESTORE REVEAL: " + this.fPathToReveal.getLastSegment());
                }
                viewer.reveal(parentPath, index);
            }
            ++this.fCounter;
            if (this.fCounter > 1 || ViewerStateTracker.this.fPendingState == null) {
                this.dispose();
            }
        }

        @Override
        public void viewerUpdatesBegin() {
        }

        @Override
        public void updateStarted(IViewerUpdate update) {
        }

        @Override
        public void updateComplete(IViewerUpdate update) {
        }

        public ModelDelta getDelta() {
            return this.fRevealDelta;
        }

        public void dispose() {
            ViewerStateTracker.this.fPendingSetTopItem = null;
            IInternalTreeModelViewer viewer = ViewerStateTracker.this.fContentProvider.getViewer();
            if (viewer == null) {
                return;
            }
            viewer.removeViewerUpdateListener(this);
            if (ViewerStateTracker.this.fPendingState == null) {
                if (DebugUIPlugin.DEBUG_STATE_SAVE_RESTORE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(ViewerStateTracker.this.fContentProvider.getPresentationContext())) {
                    DebugUIPlugin.trace("STATE RESTORE COMPELTE: " + ViewerStateTracker.this.fPendingState);
                }
                ViewerStateTracker.this.notifyStateUpdate(this.fModelInput, 7, null);
            } else {
                ViewerStateTracker.this.checkIfRestoreComplete();
            }
        }
    }
}

