/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.MultiStringMatcher;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleDocumentPartitionerExtension;
import org.eclipse.ui.console.IScrollLockStateProvider;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

public class IOConsoleViewer
extends TextConsoleViewer {
    private boolean fAutoScroll = true;
    private IDocumentListener fAutoScrollListener;
    private MultiStringMatcher lineDelimiterMatcher;

    public IOConsoleViewer(Composite parent, TextConsole console) {
        super(parent, console);
    }

    public IOConsoleViewer(Composite parent, TextConsole console, IScrollLockStateProvider scrollLockStateProvider) {
        super(parent, console, scrollLockStateProvider);
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isWordWrap() {
        return this.getTextWidget().getWordWrap();
    }

    public void setWordWrap(boolean wordwrap) {
        this.getTextWidget().setWordWrap(wordwrap);
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        IConsoleDocumentPartitioner partitioner = (IConsoleDocumentPartitioner)this.getDocument().getDocumentPartitioner();
        IConsoleDocumentPartitionerExtension partitionerExt = (IConsoleDocumentPartitionerExtension)((Object)partitioner);
        StyledTextContent content = this.getTextWidget().getContent();
        String eventText = e.text != null ? e.text : "";
        MultiStringMatcher.Match newlineMatch = this.lineDelimiterMatcher != null ? this.lineDelimiterMatcher.indexOf((CharSequence)eventText, 0) : null;
        IRegion eventRange = this.event2ModelRange(e);
        int offset = eventRange.getOffset();
        int length = eventRange.getLength();
        if (length > 0 && partitionerExt.containsReadOnly(offset, length)) {
            e.doit = false;
            ITypedRegion[] writableParts = partitionerExt.computeWritablePartitions(offset, length);
            int i = writableParts.length - 1;
            while (i >= 0) {
                int overflow;
                ITypedRegion writablePart = writableParts[i];
                int replaceOffset = writablePart.getOffset();
                int replaceLength = writablePart.getLength();
                int underflow = offset - writablePart.getOffset();
                if (underflow > 0) {
                    replaceOffset += underflow;
                    replaceLength -= underflow;
                }
                if ((overflow = replaceOffset + replaceLength - (offset + length)) > 0) {
                    replaceLength -= overflow;
                }
                content.replaceTextRange(replaceOffset, replaceLength, "");
                --i;
            }
            if (eventText.length() > 0) {
                this.getTextWidget().replaceTextRange(offset, 0, eventText);
            }
        } else if (newlineMatch != null && offset != content.getCharCount()) {
            e.doit = false;
            if (newlineMatch.getOffset() > 0) {
                this.getTextWidget().replaceTextRange(offset, length, eventText.substring(0, newlineMatch.getOffset()));
                content.replaceTextRange(content.getCharCount(), 0, eventText.substring(newlineMatch.getOffset(), eventText.length()));
            } else {
                content.replaceTextRange(content.getCharCount(), 0, eventText);
            }
            this.getTextWidget().setCaretOffset(content.getCharCount());
            this.getTextWidget().showSelection();
        } else if (partitioner.isReadOnly(offset) && partitioner.isReadOnly(offset - 1)) {
            e.doit = false;
            int insertOffset = partitionerExt.getNextOffsetByState(offset, true);
            content.replaceTextRange(insertOffset, 0, eventText);
            this.getTextWidget().setCaretOffset(insertOffset + eventText.length());
            this.getTextWidget().showSelection();
        } else {
            super.handleVerifyEvent(e);
        }
    }

    public void setReadOnly() {
        ConsolePlugin.getStandardDisplay().asyncExec(() -> {
            StyledText text = this.getTextWidget();
            if (text != null && !text.isDisposed()) {
                text.setEditable(false);
            }
        });
    }

    public boolean isReadOnly() {
        return !this.getTextWidget().getEditable();
    }

    public void setDocument(IDocument document) {
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this.getAutoScrollListener());
        }
        super.setDocument(document);
        this.lineDelimiterMatcher = null;
        if (document != null) {
            this.lineDelimiterMatcher = MultiStringMatcher.create((String[])document.getLegalLineDelimiters());
            document.addDocumentListener(this.getAutoScrollListener());
        }
    }

    private IDocumentListener getAutoScrollListener() {
        if (this.fAutoScrollListener == null) {
            this.fAutoScrollListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (IOConsoleViewer.this.fAutoScroll) {
                        IOConsoleViewer.this.revealEndOfDocument();
                    }
                }
            };
        }
        return this.fAutoScrollListener;
    }
}

