/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.jdbc.Synchronizable;

public final class GDSHelper
implements Synchronizable {
    public static final int DEFAULT_BLOB_BUFFER_SIZE = 16384;
    private final FbDatabase database;
    private final Object syncObject;
    private FbTransaction transaction;
    private boolean registerResultSets;

    public GDSHelper(FbDatabase database) {
        this.registerResultSets = !database.getConnectionProperties().getExtraDatabaseParameters().hasArgument(137);
        this.database = database;
        this.syncObject = database.getSynchronizationObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FbTransaction getCurrentTransaction() {
        Object object = this.database.getSynchronizationObject();
        synchronized (object) {
            return this.transaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTransaction(FbTransaction transaction) {
        Object object = this.database.getSynchronizationObject();
        synchronized (object) {
            this.transaction = transaction;
        }
    }

    public FbDatabase getCurrentDatabase() {
        return this.database;
    }

    public IConnectionProperties getConnectionProperties() {
        return this.database.getConnectionProperties();
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() {
        return this.database.getConnectionProperties().getExtraDatabaseParameters();
    }

    public int getDialect() {
        return this.database.getConnectionDialect();
    }

    public FbStatement allocateStatement() throws SQLException {
        return this.database.createStatement(this.getCurrentTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTransaction() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            return this.transaction != null && this.transaction.getState() == TransactionState.ACTIVE;
        }
    }

    public void executeImmediate(String statement) throws SQLException {
        this.database.executeImmediate(statement, this.getCurrentTransaction());
    }

    public FbBlob openBlob(long blob_id, boolean segmented) throws SQLException {
        BlobParameterBuffer blobParameterBuffer = this.database.createBlobParameterBuffer();
        blobParameterBuffer.addArgument(3, segmented ? 0 : 1);
        FbBlob blob = this.database.createBlobForInput(this.getCurrentTransaction(), blobParameterBuffer, blob_id);
        blob.open();
        return blob;
    }

    public FbBlob createBlob(boolean segmented) throws SQLException {
        BlobParameterBuffer blobParameterBuffer = this.database.createBlobParameterBuffer();
        blobParameterBuffer.addArgument(3, segmented ? 0 : 1);
        FbBlob blob = this.database.createBlobForOutput(this.getCurrentTransaction(), blobParameterBuffer);
        blob.open();
        return blob;
    }

    public FbTransaction startTransaction(TransactionParameterBuffer tpb) throws SQLException {
        FbTransaction transaction = this.database.startTransaction(tpb);
        this.setCurrentTransaction(transaction);
        return transaction;
    }

    public void detachDatabase() throws SQLException {
        this.database.close();
    }

    public void cancelOperation() throws SQLException {
        this.database.cancelOperation(3);
    }

    @Deprecated
    public int iscVaxInteger(byte[] buffer, int pos, int length) {
        return VaxEncoding.iscVaxInteger(buffer, pos, length);
    }

    @Deprecated
    public long iscVaxLong(byte[] buffer, int pos, int length) {
        return VaxEncoding.iscVaxLong(buffer, pos, length);
    }

    public String getDatabaseProductName() {
        return this.database.getServerVersion().getServerName();
    }

    public String getDatabaseProductVersion() {
        return this.database.getServerVersion().getFullVersion();
    }

    public int getDatabaseProductMajorVersion() {
        return this.database.getServerVersion().getMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.database.getServerVersion().getMinorVersion();
    }

    public int compareToVersion(int major, int minor) {
        int differenceMajor = this.getDatabaseProductMajorVersion() - major;
        if (differenceMajor == 0) {
            return this.getDatabaseProductMinorVersion() - minor;
        }
        return differenceMajor;
    }

    public String getUserName() {
        return this.database.getConnectionProperties().getUser();
    }

    public int getBlobBufferLength() {
        DatabaseParameterBuffer dpb = this.database.getConnectionProperties().getExtraDatabaseParameters();
        if (dpb.hasArgument(130)) {
            return dpb.getArgumentAsInt(130);
        }
        return 16384;
    }

    public String getIscEncoding() {
        return this.database.getEncodingFactory().getDefaultEncodingDefinition().getFirebirdEncodingName();
    }

    public String getJavaEncoding() {
        return this.database.getEncodingFactory().getDefaultEncodingDefinition().getJavaEncodingName();
    }

    public String getMappingPath() {
        DatabaseParameterBuffer dpb = this.database.getConnectionProperties().getExtraDatabaseParameters();
        return dpb.getArgumentAsString(136);
    }

    @Override
    public Object getSynchronizationObject() {
        return this.syncObject;
    }
}

