/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.exec;

import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisBaseResultSet;
import com.dbeaver.ee.redis.exec.RedisBaseStatement;
import com.dbeaver.ee.redis.exec.RedisResultSetSimple;
import com.dbeaver.ee.redis.exec.RedisSession;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import redis.clients.jedis.commands.JedisClusterScriptingCommands;
import redis.clients.jedis.commands.ScriptingCommands;

public class RedisEvalStatement
extends RedisBaseStatement {
    protected Object result;

    public RedisEvalStatement(RedisSession session, String query) {
        super(session, query);
    }

    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            RedisUtils.selectCurDatabase(this.session);
            if (this.getSession().supportsCommands(ScriptingCommands.class)) {
                ScriptingCommands jedis = this.session.getCommands(ScriptingCommands.class);
                this.result = jedis.eval(this.getQueryString());
            } else {
                this.result = this.session.getCommands(JedisClusterScriptingCommands.class).eval(this.getQueryString(), this.getClusterSampleKey());
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new RedisResultSetSimple(this, this.result, this.offset);
    }
}

